/*******************************************************************************
  order_fac_basis_print.c 
********************************************************************************/


#include <stdio.h>
#include "kant.h" 
#include "anf.h" 
                                                             
void     
order_fac_basis_print WITH_1_ARG (order , ord)
/*******************************************************************************
Description:
   
   Prints all fac_basis entries in the structure of order.
         

Calling sequence:
                                                           
          order       ord   :  The order ord has to be the ring of integers 
                               of a number field.
                               

      order_fac_basis_print (ord);                       

                            
History:                                 
           

   MD 07.05.92    written                    

********************************************************************************/

{
          int              i;      


    printf ("No of ideals : %d\n",order_fac_basis_ideals_count (ord));
    order_fac_basis_len (ord);

    for (i=1;i<=order_fac_basis_len (ord);i++)  
    {                         
       
      cay_print ("Prime : %d     -->\n",order_fac_basis_prime (ord,i));
      anf_ideal_faclst_write (ord,order_fac_basis_ideals (ord,i));
      printf ("\n");

    }        
}
