/*******************************************************************************
  order_max_p.c 
********************************************************************************/


#include <stdio.h>             
#include "kant.h"
#include "anf.h"
#include "mat.h"



order order_max_p     WITH_3_ARGS (order,          ord,
                                   integer_big,    prime,
                                   integer_small,  prime_degree)
/*******************************************************************************

Description:
  
     Computation of a p-max. order                   					
     The subrouine "order_max_p" computes the p-maximal overoder starting 
     from a given suborder (usually this will be Z[rho] ).

     The alg. used is decribed in                                                                  
          Pohst  : Konstruktive Zahlentheorie I  (Chapter 2) "Round 2"
                                                                                               
                                                                                            
Calling sequence:       
                                                                  
         order          start_order   :  The p-max. overorder will be computed 
                                         relaive to this order.   
         integer_big    prime         :  The computation will be down with 
                                         this primenumber
                                
         integer_small  prime_degree  :  > 0 : A upper bound for 
                                                 log index (p-max. order)  
                                                    p                      
                                         = 0 : no such bound is known.                     

         order          p_max_order   :  The return - value of this function is 
                                         the p-max. overorder relative to the 
                                         given parameters.
                                       
                                                                                               
       p_max_order = order_max_p (start_order,prime,prime_degree);           
                                                                                               

History:
                                
      MD 92-04-09  modul deleted
   MD/JS 92-03-11  modified mult_ring handling
      JS 92-02-27  better output
      MD 91-12-10  memory check
      MD 91-11-10  first version                                       					

********************************************************************************/
{                              
     block_declarations;         
 

     order            Z,mult_ring,akt_ord;
     anf_ideal        p_radical;   
     matrix           trans_mat;

     integer_big      den_inv_trans_mat;
     integer_big      modul;    
/*     
     integer_big      index; 
 */

     integer_small    rel_degree;
     integer_small    lauf,i,k,l;
     integer_small    index_exponent,modul_exponent;


     t_logical          ok,ende;



/* for memory debugging : 
     int              u0,u1;
    
     u0 = bh_used_space ();  
     u1 = bh_used_space ();  
     printf ("\n  1.1.1) Speicher : Verbrauch:                  %d\n",u1-u0);

*/     
                                  

/* The local variables ::
*/
         
                           
  if (anf_print_level >0)
  {
    puts ("Calculation of p-maximal overorder...");
    cay_print ("Prime: %d   maximal exponent: %d \n",prime,prime_degree);
  }

  Z = order_coef_order(ord);                          /* the rational integers */


  lauf  = 0;                                          /* Number of passes until the solution is comuted. */
  ende  = FALSE;                                      /* The solution has not been reached so far        */

  modul          = 0;                                 /* There will be a delref in a loop                */
  modul_exponent = prime_degree;
             
  index_exponent = 0;


  akt_ord   = order_incref (ord);                     /* Save the pointer of the given order  */


  rel_degree = order_rel_degree (ord);                /* rel_degree ist der Grad der Ordnung ord. rel. zu   */
                                                      /* ihrer Koeff. - Ord. Da die Ordnung jedoch ueber Z  */
                                                      /* sein muss gilt : rel_degree = abs_degree.          */



  do                                                  /* Solange bis p-max. Oberord. gefunden ist ! */
  {                                                  

    lauf++;                                           /* Ein Durchlauf mehr bis zur Loesung                      */

    integer_delref (modul);
    modul = integer_power (prime,modul_exponent);     /* Es kann alles modulo modul berechnet werden. */

    if (! order_mult_table_known (akt_ord))           /* Im weiteren werden die Mult. - tabellen noch ben,. */
      order_mult_table_create (akt_ord);


/* Berechnung von NR(pR)  mit R = akt_ord                     */
/*                                                            */
/*                                                            */

    p_radical = order_p_radical (akt_ord,prime);


/* Berechnung des Multiplikatorringes von [NR(pR) / NR(pR)]   */
/*                                                            */
/*                                                            */

/*  trbl_set_trace_handle (-113);   */
    mult_ring  = anf_ideal_mult_ring (akt_ord,p_radical,modul);
    anf_ideal_delete (akt_ord,&p_radical);                 
/* trbl_set_trace_handle (1);           */


/*
   mult_ring is a really larger than akt_ord iff:
        -- mult_ring is defined via a trafo matrix over akt_ord and
        -- the index is larger than 1
*/
    if (   order_basis_is_rel(mult_ring) 
        && order_suborder(mult_ring) == akt_ord  
        && order_index (mult_ring) != 1) 
    {
 
                                           
      k = integer_prime_exponent  (prime,order_index (mult_ring));     

      index_exponent += k;       
    
      if (prime_degree != 0)                                    /* This is only necessary if prime_dregree is not equal zero */
        modul_exponent -= k;
              
      if (anf_print_level >1)
      {
        cay_print ("relative degree found: %d\n",order_index (mult_ring));
        if (anf_print_level >2)
        {
        cay_print ("Transformation (von oben nach unten): (Denominator = %d)\n",order_tran_den (mult_ring));
        mat_anf_write (Z,order_tran (mult_ring));   
        }
        cay_print ("Index exponent found until now: %d\n",index_exponent);
      }                                

      order_delete (&akt_ord);      

      akt_ord = order_simplify_trans (mult_ring);   /* Fuer lauf  = 1 passiert hier nichts */
      order_delete (&mult_ring);

      if ((modul_exponent < 2) && (prime_degree != 0)) 
        ende= TRUE; 
    }      
    else  
     { 
       if (lauf == 1)
        {
         akt_ord = mult_ring;  /* Es gilt zwar (math.) akt_ord = mult_ring       */
                               /* jedoch ist mult_ring ueber eine Transformation */
                               /* gegeben und akt_ord bei erstem Durchlauf i.a.  */
                               /* nicht.                                         */
        }
        else
        {
         order_delete (&mult_ring);
        }
          
       ende = TRUE;
     }

  } while (!ende);                          
                  
  integer_delref (modul);
/*  integer_delref (index); */
                        
/*  if (anf_print_level>10) 
  {
    printf ("-------------------------------------------- Verbrauchter Speicher (order_max_p): %d\n",bh_used_space ()-mem);
  }
*/

  return akt_ord;
}   
 
       
