#include <stdio.h>          
#include "kant.h" 
#include "anf.h" 
#include "lattice.h" 
#include "real.e"


anf_elt
order_primitive_elt WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:
 
	The function returns an arbitrary primitive element of ord.
        This element is usually the second basis element. If that
        does not work we look in a suborder for a candidate.

 
Calling sequence:
 
	alpha = order_primitive_elt(ord);
 
      	order  	        ord      = t_handle of an order 
      	anf_elt         alpha    = t_handle of a primitive algebraic number 
				   in ord
      
 
History:
 
	92-07-06 JS    trying to a get a better one 
	92-04-02 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	integer_small	n;

	order		sub_ord;
	anf_elt 	alpha, beta;

	n=  order_abs_degree(ord);

        alpha = order_basis_elt(ord,2); 
 
	if (order_basis_is_pure(ord) || order_basis_is_power(ord) )
	{   
        	return alpha;
	}
	else
	{
                if (anf_elt_is_primitive(ord, alpha)) return alpha;
 
                /* this does not work ... */
 
		if (!order_basis_is_rel(ord))
		error_internal("order_primitive_elt: Unknown situation.");

                /* lift a primitive element of suborder */
 
        	anf_elt_delref(ord,&alpha);
		sub_ord = order_suborder(ord);
		beta    = order_primitive_elt(sub_ord);

		alpha   = anf_elt_move(sub_ord, beta, ord);
		anf_elt_delref(sub_ord,&beta);
		return alpha;
	 }
} 

