#include "kant.h" 

t_void
order_reg_calc WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description: 

        Computes the regulator of the unit group is possible.
        This the determinant of a lattice basis of the logarithm space of
        the units (where one row is removed), multiplied by a certain 
	power of 2.

Calling sequence:
 
	order_reg_calc(ord)

	order	ord	= order under consideration
 
History:
        93-01-25 MJ/KW  order_units_logs_assure
	92-09-08 JS	ring_create_one replaced by conv_int_to_real
	92-04-01 JS	new unit representation (r1+r2 rows, 2-power)
	92-01-27 JS	imaginary quadratic fields
	91-10-01 JS	first version
 
*******************************************************************************/
{
	block_declarations;
 
	t_handle		R,Rchol;
	t_real		det, detsq, two, two_power, temp;
        matrix          logs, submat, cholmat,grammat;
        integer_small   r, r2, xpo;  

        matrix          echo,ltrans,rtrans;
    

	R  = order_reals(ord); 

        r  = order_r(ord);
        r2 = order_r2(ord);
  
	if (!order_units_are_maximal(ord))
		error_internal("Not enough units for regulator computation.");
 
        if (r == 0)
        {
                order_reg(ord) = conv_int_to_real(R, 1);
                return;
        }   
    
        order_units_logs_assure(ord);
                 
        submat = mat_ring_submat(R, order_units_logs(ord), 1, 1, r, r);
 
/*	MJ 19.3.1993
        The Magma does not work well. Therefore we use 
        our own echelon routine.
        
        mat_fld_det_sub(R, submat, &det); 
*/   

/*      That's a more complicated way. However it works   


        Rchol = ring_incref(R);  
        grammat = mat_ring_gram(R,submat);
        cholmat = mat_ring_gram_chol(R,grammat,&Rchol);   
        mat_ring_write(Rchol,cholmat);                  
        mat_fld_det_sub(R,cholmat,&detsq);
        det = real_root(R,detsq,2); 
*/
        

        mat_real_echelon(R,submat,&echo,&ltrans,TRUE,&rtrans);  
        mat_fld_det_sub(R,echo,&det);
        mat_delref(R,&ltrans);
        mat_delref(R,&rtrans);
        mat_delref(R,&echo);
 
        xpo 	  = (r2 < 2) ? 0 : r2-1;
        two 	  = conv_int_to_real(R, 2);
        two_power = real_power(R, two, xpo);   


 
	if (real_sign(R, det) < 0)
		temp = real_negate(R, det);
        else
		temp = real_incref(det);
 
	order_reg(ord) = real_mult(R, temp, two_power);
 
	if (anf_print_level > 2)
	{
		printf("Regulator = ");
		real_write(R, order_reg(ord), 80);
		printf("\n");
	}
        
        mat_delref(R, &submat);
	real_delete(&det);
        real_delete(&two);
        real_delete(&two_power);
	real_delete(&temp);
 
	return;
}

