/******************************************************************************
  order_relation_eval_torsion_subgroup.c
******************************************************************************/
#include "kant.h"

t_void
order_relation_eval_torsion_subgroup WITH_1_ARG (
	order,		ord
)

/******************************************************************************
 
Description:	Computes a generator of the torsion subgroup and sets
		the rank of the torsion subgroup inside the order structure.
 
Calling sequence:  

	order_relation_eval_torsion_subgroup(ord)

	ord	=	t_handle of order
 
History:
 
	92-06-12 KW	minor changes
	92-06-09 KW	written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		alpha,beta,gamma,delta;
	t_handle	R;
	integer_small	c,i,n;
	t_real		temp,tempim,tempre,tempu; 
	
	if (order_torsion_unit(ord)) return;

	if (order_r1(ord))
	{
		order_torsion_rank(ord) = 2;
		order_torsion_unit(ord) = -1;
		return;
	}

	R = order_reals(ord);
	temp = conv_int_to_real(R,2);

	n = order_relation_count(ord);
	gamma = -1;

	for (i=1,c=1;i<=n;i++)
	{
		alpha = anf_elt_incref(order_relation_number(ord,i));
		if (anf_elt_is_torsion_unit(ord,alpha)
			&& !anf_elt_is_integer_sub(ord,alpha,&beta))
		{
			c++;

			beta = anf_elt_con(ord,alpha);
			tempre = anf_con(beta,1);
      			tempim = anf_con(beta,order_r2(ord)+1);

			if (!(real_sign(R,tempim)*real_sign(R,tempre) < 0))
			{
				if (real_sign(R,tempim) == -1)
				{
					tempu = real_negate(R,tempim);
					delta = alpha;
					alpha = anf_elt_negate(ord,alpha);
					anf_elt_delete(ord,&delta);
				}
				else tempu = real_incref(tempim);

				if (real_compare(R,tempu,temp) == -1)
				{
					anf_elt_delete(ord,&gamma);
					gamma = anf_elt_incref(alpha);
					real_delete(&temp);
					temp = real_incref(tempu);
				}
				real_delete(&tempu);
			}
			anf_elt_delete(ord,&beta);
		}
		anf_elt_delete(ord,&alpha);
	}
	real_delete(&temp);

	order_torsion_rank(ord) = c+c;
	order_torsion_unit(ord) = gamma;
	if (anf_print_level > 0)
	{
		printf("order_torsion_unit: ");
		anf_elt_write(ord,order_torsion_unit(ord));
		printf(" (rank is %d).",order_torsion_rank(ord));
		printf("\n");
	}
}
