#include "kant.h"
 
#define  MAX_ITERATIONS 15
t_logical
order_short WITH_3_ARGS(
                order,          ordin,
                t_int,          modus,
                order *,        ord_short
)
/*******************************************************************************
 
Description: 
	Computes equation order with better minimal polynomial for the number field
	given by ord. If modus != 0 it tries to find a field, where modus is not
        a divisor of the index.	If it is successful TRUE is returned.


Calling sequence: 
        L = order_shortest(ord, modus, &ord_short)
        
        t_logical               L
        order                   ord, ord_short
        t_int                   modus
   
History:
	93-03-25 MJ,JPS    written, not really memory debuged.
 
*******************************************************************************/
{
	block_declarations;
        
        t_handle        Z;
        t_logical       order_found;
        order           ord,ord_max, ord_eq, ord_lll, ord_min;
        t_int           cnt,i,deg, deg_pol_gamma, disc, disc_ord_eq, disc_ord_min, rem, index;  
        t_int           dmin,dneu;
        vector          v,v1;
        anf_elt         gamma;
        t_poly          pol,pol_gamma;
         
        Z = m_z_str_incref(structure_z);  

	if( order_basis_is_power( ordin))
		pol = m_poly_z_incref( Z, order_poly( ordin ) );
	else
		pol = m_poly_z_incref( Z, order_poly(
			order_suborder( ordin ) ));     

        ord = order_equation_create(Z,pol);
 

        order_disc_assure(ord);
        disc = order_disc(ord);  
/*
        For description of the counter cnt 
        see at the end of the while loop.
*/
        cnt = 0;

        ord_min = order_incref(ord);
        disc_ord_min = order_disc(ord_min);   

        dmin = integer_abs(disc_ord_min);

        deg = order_abs_degree(ord);

        ord_max = order_maximal(ord);
        ord_lll = order_lll_reduce(ord_max);

        order_found = FALSE;
/*      
        At first we initialize the loop. We use small linear combinations 
        of a LLL reduced basis 

          gamma = {0,1} omega_1 + ....... + {0,1} omega_n
*/
        v1 = vector_index_init(deg, 0);  
        while (vector_index_inc(v1, 0, 1))
                { 
                v = vec_new(deg); 
                for(i=1;i<=deg;i++) vec_entry(v,i) = integer_incref(vec_entry(v1,deg-i+1));
                gamma = vec_to_anf_elt(ord_lll, v); 
                vec_delete(Z, &v);
                /*anf_elt_write (ord_lll,gamma); puts(""); */
                pol_gamma = anf_elt_minpoly(ord_lll, gamma);
                deg_pol_gamma = poly_deg(pol_gamma);  
/*              
                We check whether the degree of the minimal polynomial 
                of gamma is equal to the degree of the input order.
*/
                
                if (deg_pol_gamma == deg)
                        {     
                        cnt = cnt + 1;
                        if ( !order_found ) cnt = cnt - 1;
                        ord_eq = order_equation_create(Z, pol_gamma);
                        order_disc_assure(ord_eq);
                        disc_ord_eq = order_disc(ord_eq);     
                        dneu  = integer_abs(disc_ord_eq);
                 	index = integer_div(dneu, order_disc(ord_lll));   
/*                      
                        Checking the abolute values of the discriminants.
                        If the new order has a discriminant of smaller size in
                        absolute values we take that one. 

                        In case modus not equal zero we test whether modus is 
                        not an index divisor. If modus does not divide the index 
                        we take the new order   
 
                        In both cases, if we take the new order,  we reset the 
                        counter cnt to zero. 
*/
			if ((integer_compare(dneu, dmin ) < 0) && (modus == 0))
                                {   
                                cnt = 0;
                                order_found = TRUE;
                                order_delete(&ord_min);
                                disc_ord_min = order_disc(ord_eq);   
                                integer_delref(dmin);
                                dmin = integer_abs(disc_ord_min);
                                ord_min = order_incref(ord_eq);  
                                /*order_write(ord_min);*/
                                }
                        if ((integer_compare(dneu, dmin ) < 0) && (modus != 0))
                                {
                                rem = integer_rem(index, modus);
                                if (rem != 0)
                                        {  
                                        cnt = 0;
                                        order_found = TRUE;
                                        order_delete(&ord_min);
                                        disc_ord_min = order_disc(ord_eq);  
                                        integer_delref(dmin);
                                        dmin = integer_abs(disc_ord_min);
                                        ord_min = order_incref(ord_eq);
                                        }
                                integer_delete(&rem);
                                }
                        order_delete(&ord_eq);
                        integer_delete(&index);
                        integer_delref(dneu);
                        }
	        m_poly_z_delref(structure_pring_z,pol_gamma);
                anf_elt_delete(ord_lll, &gamma);    

/*              
                MAD, but useful. We believe in the following strategie. If we 
                had found an appropriate order, see the if statements, the 
                counter was zeroed. If we now found more than MAX_ITERATIONS 
                of orders that do not produce a "better" fields we break. 
                "Better" here means that all of such orders have a larger 
                discriminant in absolute values compared to out choice 
                ord_min and if required that modus does not divide the index.   
  
                Clearly, we break too if all small combinations are tested.
*/
              
                if ( cnt > MAX_ITERATIONS ) break;
                }
        order_delete(&ord_max);
        order_delete(&ord_lll);
        vec_delete(Z, &v1);
	ring_delete(&Z);
	*ord_short = ord_min;

        return order_found;
}
