/******************************************************************************
  order_units_logs_reg_calc.c
******************************************************************************/
 
#include "kant.h"
#include "real.e"
#include "mat.e"
#include "anf.h"
#include "conv.e" 

t_real
order_units_logs_reg_calc WITH_2_ARGS(
	order,		ord,
        matrix, 	mat
)
/*******************************************************************************
 
Description: 

        Computes basically the determinant of the matrix submitted,
        expecting that it contains logarithm vectors (length r1+r2)
        of a maximal independent system of units of the order.
        The matrix must have square dimension r1+r2.

Calling sequence:
 
	reg = order_units_logs_reg_calc(ord, mat)

	order	ord	= order under consideration
        matrix  mat     = log vectors of units
        t_real  reg     = regulator of system

 
History:
 
	92-05-06 JS	first version
 
*******************************************************************************/
{
	block_declarations;
 
	t_handle		R;
	t_real		reg, det, two, two_power, temp;
        matrix          logs, submat;
        integer_small   r, r2, xpo;
    

	R  = order_reals(ord);
        r  = order_r(ord);
        r2 = order_r2(ord);
  
        submat = mat_ring_submat(R, mat, 1, 1, r, r);
 
	mat_fld_det_sub(R, submat, &det);
 
        xpo 	  = (r2 < 2) ? 0 : r2-1;
        two 	  = conv_int_to_real(R, 2);
        two_power = real_power(R, two, xpo);

 
	if (real_sign(R, det) < 0)
		temp = real_negate(R, det);
        else
		temp = real_incref(det);
 
	reg = real_mult(R, temp, two_power);
 
        mat_delref(R, &submat);
	real_delete(&det);
        real_delete(&two);
        real_delete(&two_power);
	real_delete(&temp);
 
	return reg;
}
