#include "kant.h"
#include "poly.h"
#include "dyn_arr.h"

dyn_arr_handle
poly_to_dyn_arr WITH_2_ARGS(
	t_handle,		cring,
	t_poly,	pol
)
/*******************************************************************************
 
poly_to_dyn_arr.c
 
JS October 1991 
Last modification: 21.10.91
      
Expands the coefficients of a polynomial into an array which now
contains all coefficients, increasing and with leading coefficient.
 
*******************************************************************************/
{
	block_declarations;         
 
	dyn_arr_handle  arr;
	integer_small	i, nterms, length;
	t_handle		polh;
 
	if (m_poly_const(pol))
	{
		arr = dyn_arr_alloc(1);
		dyn_arr_element(arr, 0) = ring_elt_incref(cring, pol);
		dyn_arr_curr_length(arr) = 1;
	}
	else
	{
		polh = m_poly_poly_to_handle(pol);
 
		nterms = m_poly_nterms(polh);       
		length = m_poly_expt(polh, nterms-1) + 1;
	 
		arr = dyn_arr_alloc(length);
		for (i=0; i<length; ++i) dyn_arr_element(arr, i) = 0;
	 
		for (i=0; i<nterms; ++i)
		{
			dyn_arr_element(arr, m_poly_expt(polh, i)) = 
			ring_elt_incref(cring, m_poly_coefft(polh, i));
		} 
	 
		dyn_arr_curr_length(arr) = length;
	}
 

	return arr;
}
