/******************************************************************************
  real_hermite_const_ubound.c
******************************************************************************/
#include "kant.h"

t_real
real_hermite_const_ubound WITH_2_ARGS (
	t_handle,		rrng,
	integer_small,	n
)

/******************************************************************************
 
Description:	Computes an upper bound for Hermite's constant. See:
		M. Pohst and H. Zassenhaus, "Algorithmic Algebraic Number Theory", 
		Cambridge Univ. Press 1989, 198-199.
 
Calling sequence:
 
	gamma = real_hermite_const_upper_bound(R,n)
 
History:
 
	92-05-29 KW	written
 
******************************************************************************/
{
	block_declarations;

	t_real		gamma;
	t_real		temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9;

	switch (n)
	{
	case 1	:	gamma = ring_one(rrng);
			break;
	case 2	:	temp1 = conv_int_to_real(rrng,4);
			temp2 = conv_int_to_real(rrng,3);
			gamma = real_divide(rrng,temp1,temp2);
			real_delete(&temp1);
			real_delete(&temp2);
			break;
	case 3	:	gamma = conv_int_to_real(rrng,2);
			break;
	case 4	:	gamma = conv_int_to_real(rrng,4);
			break;
	case 5	:	gamma = conv_int_to_real(rrng,8);
			break;
	case 6	:	temp1 = conv_int_to_real(rrng,64);
			temp2 = conv_int_to_real(rrng,3);
			gamma = real_divide(rrng,temp1,temp2);
			real_delete(&temp1);
			real_delete(&temp2);
			break;
	case 7	:	gamma = conv_int_to_real(rrng,64);
			break;
	case 8	:	gamma = conv_int_to_real(rrng,256);
			break;
	default	:	temp1 = conv_int_to_real(rrng,2);
			temp2 = real_pi(rrng);
			temp3 = real_divide(rrng,temp1,temp2);
			temp4 = real_power(rrng,temp3,n);
			temp5 = conv_int_to_real(rrng,n);
			temp6 = real_divide(rrng,temp5,temp1);
			temp7 = real_add(rrng,temp6,temp1);
			temp8 = real_gamma(rrng,temp7);
			temp9 = real_mult(rrng,temp8,temp8);
			gamma = real_mult(rrng,temp4,temp9);
			real_delete(&temp1);
			real_delete(&temp2);
			real_delete(&temp3);
			real_delete(&temp4);
			real_delete(&temp5);
			real_delete(&temp6);
			real_delete(&temp7);
			real_delete(&temp8);
			real_delete(&temp9);
			break;
	}
	return(gamma);
}
