/******************************************************************************
  vector_index_inc.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "vector.h"

t_logical
vector_index_inc WITH_3_ARGS(
	vector,		vec,
	integer_small,	lbound,
	integer_small,	ubound
)
/*******************************************************************************
 
Description:
                
	Increment of the index vector vec of length "length".
	All entries run from lbound to ubound.
	The routine will return TRUE until
	vec = ( ubound, ..., ubound ) and then FALSE.
	Be careful: vector_index_init initializes the last
	entry of vec with lbound-1 and expects the increment routine
	before your loop !

  
Calling sequence:
 
        vector_index_inc( vec, lbound, ubound );
                                             
	vector		vec:	   index vector
        integer_small  	lbound:    lower bound
        integer_small  	ubound:    upper bound

 
History:

	92-06-11 CO     first version

*******************************************************************************/
{       
	block_declarations;
                          
	integer_small	i, len;

	len = vec_length( vec );
	vec_entry( vec, len ) ++;
	for( i = len; vec_entry( vec, i ) > ubound; i-- )
	{
		if( i == 1 )
			return 0;
		vec_entry( vec, i ) = lbound;
		vec_entry( vec, i-1 ) ++;
	}

	return 1;
}
