
/*
 * The functions in this file return a COPY of the Re and Im parts of 
 * a complex number - comp_split_mp returns the actual members
 * so that they may be modified.
 */

#include "defs.h"
#include "real.e"
#include "mp.e"
#include "comp.e"

t_real
comp_re WITH_2_ARGS(
	t_handle,		r,
	t_comp,		x
)
/*
** Returns Re( x ).
*/
{
	mp_float	xre;
	mp_float	yf;

	comp_get_real( x, xre );
	yf = mp_alloc( real_base, comp_beta_prec( r ));
	mp_priv_copy( xre, yf );

	return mp_to_real( yf );
}


t_real
comp_im WITH_2_ARGS(
	t_handle,		r,
	t_comp,		x
)
/*
** Returns Im( x ).
*/
{
	mp_float	xim;
	mp_float	yf;

	comp_get_imag( x, xim );
	yf = mp_alloc( real_base, comp_beta_prec( r ));
	mp_priv_copy( xim, yf );

	return mp_to_real( yf );
}

