
#include "defs.h"
#include "ring.e"
#include "comp.e"

t_comp
comp_sqrt WITH_2_ARGS(
	t_handle,		r,
	t_comp,		a
)
/*
** Returns sqrt(a)
*/
{
	mp_float	cim, cre, af_arg, af_mod, cf_arg, cf_mod;
	t_real		a_arg, a_mod;
	t_comp	c;

	cf_arg = mp_alloc( real_base, real_beta_prec( r ));
	cf_mod = mp_alloc( real_base, real_beta_prec( r ));

	a_mod = comp_modulus (r, a);
	real_make_mp (a_mod, af_mod);
	mp_sqrt (af_mod, cf_mod);

	a_arg = comp_arg (r, a);
	real_make_mp (a_arg, af_arg);
	mp_div_int (af_arg, 2, cf_arg);

	c = comp_alloc( real_base, comp_beta_prec( r ));
	comp_split_mp( c, cre, cim );

	comp_polar_to_cart (r, cf_mod, cf_arg, &cre, &cim);

	mp_delete_float (cf_arg);
	mp_delete_float (cf_mod);
	return c;
}

