#include "defs.h"
#include "mp.e"
#include "mp.h"
#include "integer.e"
#include "conv.e"

static integer_big conv_mp_to_int P_((mp_float,mp_round_type));


static integer_big
conv_mp_to_int	WITH_2_ARGS(
	mp_float,	x,
	mp_round_type,	round
)
/*
Returns the (big) integer part of multi-precision x with rounding
determined by the the parameter round.
*/
{
    block_declarations;
    mp_ptr_type		xp = mp_ptr(x);
    mp_sign_type	sign;
    mp_base_type	b, b2;
    mp_expt_type	expt;
    mp_length		t, i, intdigs;
    integer_big		result, temp, incr;

    if (mp_is_zero(xp))
	return 0;

    b = mp_b(xp);
    t = mp_t(xp);
    sign = mp_sign(xp);
    expt = mp_expt(xp);

    intdigs = expt < t? expt: t;
    result = 0;

    for (i = 0; i < intdigs; i++)
    {
	if (i)
	{
	    temp = result;
	    result = integer_mult(result, b);
	    integer_delref(temp);
	}

	temp = result;
	result = integer_add(result, mp_digit(mp_ptr(x), i));
	integer_delref(temp);
    }

    if (expt > t)
    {
	integer_big	scale;

	scale = integer_power(b, expt - t);
	temp = result;
	result = integer_mult(result, scale);
	integer_delref(temp);
	integer_delref(scale);
    }
    else if (expt < t)
    {
	xp = mp_ptr(x);

	switch (round)
	{
	case MP_TRUNC:
		incr = 0;
		break;
	case MP_RND:
		incr = 0;
		b2 = b / 2;

		/*
		See mp_nzr() for comments.
		*/

		if (b % 2 == 0)
		{
		    if (mp_digit(xp, expt) >= b2)
			incr = 1;
		}
		else
		{
		    for (i = expt; i < t; i++)
			if (mp_digit(xp, i) != b2)
			    break;

		    if (i == t || mp_digit(xp, i) > b2)
			incr = 1;
		}
		break;
	case MP_RND_UP:
		if (sign > 0 && !mp_all_zero(mp_digit_ptr(xp, expt), t - expt))
		    incr = 1;
		else
		    incr = 0;
		break;
	case MP_RND_DOWN:
		if (sign < 0 && !mp_all_zero(mp_digit_ptr(xp, expt), t - expt))
		    incr = 1;
		else
		    incr = 0;
		break;
	}

	if (incr)
	{
	    temp = result;
	    result = integer_add(result, incr);
	    integer_delref(temp);
	}
    }


    if (sign < 0)
	result = integer_destructively_negate(result);

    return result;
}


integer_big
conv_mp_to_int_floor	WITH_1_ARG(
	mp_float,	x
)
/*
Returns the floor of x as a big integer.
*/
{
    return conv_mp_to_int(x, MP_RND_DOWN);
}


integer_big
conv_mp_to_int_ceil	WITH_1_ARG(
	mp_float,	x
)
/*
Returns the ceiling of x as a big integer.
*/
{
    return conv_mp_to_int(x, MP_RND_UP);
}


integer_big
conv_mp_to_int_trunc	WITH_1_ARG(
	mp_float,	x
)
/*
Returns the big integer closest to x which is also closer than to 0 than x.
(i.e. rounding is toward 0.)
*/
{
    return conv_mp_to_int(x, MP_TRUNC);
}


integer_big
conv_mp_to_int_round	WITH_1_ARG(
	mp_float,	x
)
/*
Returns the big integer closest to x.
*/
{
    return conv_mp_to_int(x, MP_RND);
}

