/*  integer_negate.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_negate WITH_1_ARG(integer_big, i)
/*
Return the additive inverse of the argument
*/
{
    inthdl_handle	invhdl;
    inthdl_handle	ihdl;

    if (integer_is_single(i))
	return -i;

    ihdl = inthdl_big_to_handle(i);
    invhdl = inthdl_alloc(intbig_curr_size(ihdl));
    inthdl_negate(ihdl, invhdl);

    return inthdl_handle_to_big(invhdl);
}


integer_big
integer_destructively_negate WITH_1_ARG(integer_big, i)
/*
Destructively negates i and returns i, i.e. if i is single, returns -i, and
if i refers to a block, changes the sign contained in that block and
returns i (which refers to the same block again).  This means that when
one wants to negate a number and forget the original, one does not have to
waste time allocating a new block for the negative and deleting the old.
*/
{
    inthdl_handle	ihdl;

    if (integer_is_single(i))
	return -i;

    ihdl = inthdl_big_to_handle(i);
    inthdl_negate(ihdl, ihdl);

    return inthdl_handle_to_big(ihdl);
}
