#include "defs.h"
#include "error.e"

Void
integer_prod_factorise WITH_3_ARGS(
    t_int,      list,
    t_int,      len,
    t_int *,    facts
)
/*
** input:  list - stack of length len containing numbers whose product is to
** be factorised
*/
{
	t_int		newf;
	register t_int	lindex;
	t_int		nextf;
	register t_int	temp;
	t_int             rems;

	integer_stk_factorise( fitem(list, 1), facts, &rems, 10,
1000, 1023, 10, 500, 3, 100, fitem(list, 1), 1 );

	if (rems != 0)
		    error_runtime(ERR_COULD_NOT_FACTOR_ARG, 1);

	sexts(*facts, 1);

	newf = sh_newstk(items(*facts), 2, bpf(*facts), 1, 1);


	for (lindex = 2; lindex <= len; lindex++)
	{
		integer_stk_factorise( fitem(list, lindex), &nextf, &rems, 10,
1000, 1023, 10, 500, 3, 100, fitem(list, lindex), 1 );

		DENY(rems != 0);

		facint_mult(*facts, nextf, newf);
		facint_delete(&nextf);
		temp = *facts;
		*facts = newf;
		newf = temp;
	}

	reduce(*facts, ffld(*facts, 1, 1) + 1);
	facint_delete(&newf);

}
