#include "defs.h"
#include "integer.e"
#include "mat.h"
#include "att.h"

matrix
mat_new WITH_2_ARGS(
	integer_small,    m,
	integer_small,    n
)
/*
** returns a new matrix of size m * n, setting rows, cols, packed, to correct
** values.
*/
{
	t_handle	h;

	h = mem_alloc_words_zero( mat_req_size( m, n ) );
	block_init(h, MAT_BLOCK_TYPE);
	mat_row(h) = m;
	mat_col(h) = n;
	att2_set_all_false( mat_flgs(h), (int) MAT_ATT_TOTAL );

	return h;
}
