#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"
#include "ring.h"
#include "mat.h"

t_void
mat_pack WITH_3_ARGS(
	t_handle,      ring,
	matrix,      a,
	matrix *,    b
)
/*
** packs matrix a into *b, allocating space for *b if *b == 0. Coefficient
** ring is ring.
*/
{
	int	matsz;
	int	pksz;

	if ( !ring_is_packed( ring ) )
	{
		error_internal( "mat_pack: tried to pack unpackable ring, type is %d\n", ring_type( ring ));
	}

	switch( ring_type( ring ) )
	{
	case RING_ZM:
		break;
	default:
		error_internal( "mat_pack: tried to pack packable but unregistered ring, type is %d\n", ring_type( ring ));
	}

	if ( *b == 0 )
		*b = mat_new( mat_row(a), mat_col(a) );

	mat_copy_entries( ring, a, *b );
	mat_set_pack( *b );
}

