#include "defs.h"
#include "ring.h"
#include "mat.h"

void
mat_ring_echelon WITH_10_ARGS(
	t_handle,		ring,
	matrix,		a,
	t_int		*,	det,
	t_int		*,	rank,
	matrix 	*,	echelon,
	Logical *,	unit,
	Logical, 	istoreduce,
	matrix	*,	transform,
	Logical,	istoinverse,
	t_int,		start_row
)
/*
 * This procedure will find out determinant, rank, standard echelon form of a,
 * reduced echelon form, standard echelon transform, reduced echelon transform,
 * inverse and test whether a is unit.
 */

{
	switch( ring_type( ring ))
	{
	case RING_Z:
		mat_z_echelon(ring, a, det, rank, echelon, unit, istoreduce, transform, istoinverse, start_row);
		return;

	case RING_ZM:
		mat_zm_echelon(ring, a, det, rank, echelon, unit, istoreduce, transform, istoinverse, start_row);
		return;
	default:
		break;
	}

	if (ring_is_field(ring))
	{
		mat_fld_echelon(ring, a, det, rank, echelon, unit, istoreduce, transform, istoinverse, start_row);
		return;
	}
/*
	if ( ring_is_ed( ring ))
        {
		mat_ed_echelon(ring, a, det, rank, echelon, unit, istoreduce, transform, istoinverse, start_row);
		return;
	}
*/
	error_internal("No echelon function available");
}

