
#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"

Logical
mat_z_equal WITH_3_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b
)
/*
 * Test two matrices to see if they are equal.
 * Returns TRUE if they are.
 */
{
	block_declarations;
	register t_int	i;
	register t_int	dsquared;
	register t_int	*ptr_a;
	register t_int	*ptr_b;
	matrix	mata;
	matrix	matb;
	t_int		m;
	t_int		n;

	/*
	 * This function assumes matrices have to be unpacked to be compared for equality
	 */

	m = mat_row(a);		 n = mat_col(a);
	if (m != mat_row(b) || n != mat_col(b))
		error_internal("Matrices not same dimension in EQUAL");

	mata = matb = 0;

	mat_create_unpkd(ring, a, mata, m, n);
	mat_create_unpkd(ring, b, matb, m, n);

	ptr_a = mat_elt0_ptr(mata);
	ptr_b = mat_elt0_ptr(matb);
	dsquared = m * n;
	/*
	 * Scan each element of the matrices.
	 * i represents index to matrix
	 */
	for (i = 1; i <= dsquared; i++)
	{
		/*
		 * should be equal
		 */
		if (integer_compare(ptr_a[i], ptr_b[i]))	/* not equal */
		{
			mat_free_unpkd(a, mata);
			mat_free_unpkd(b, matb);
			return FALSE;
		}
	}

	mat_free_unpkd(a, mata);
	mat_free_unpkd(b, matb);
	return TRUE;
}
