#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"
#include "zm.e"


t_void
mat_zm_mult_sub WITH_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	matrix,		b,
	matrix *,	pc
)
/*
** *pc := a * b, a and b matrices over integer module cring.
*/
{
	block_declarations;
	register t_int	i;
	register t_int	j;
	register t_int	k;
	register t_int	temp1;
	register t_int	temp2;
	register integer_big	s;
	register t_int	am;
	register t_int	an;
	register t_int	bm;
	register t_int	bn;
	matrix	mata;
	matrix	matb;
	matrix	matc;
	t_int		modulus;
	Logical	respack;

	mata = matb = matc = 0;

	am = mat_row(a);		an = mat_col(a);
	bm = mat_row(b);		bn = mat_col(b);

	if (an != bm)
		error_internal("Wrong dimensions for matrix multiplication");

	respack = mat_result_pkd(cring, *pc);

	mat_alloc_result_unpkd(respack, *pc, matc, am, bn);

	mat_create_unpkd(cring, a, mata, am, an);
	/*
	 * if a and b are the same matrix, don't unpack b
	 */
	if (a != b)
	{
		mat_create_unpkd(cring, b, matb, bm, bn);
	}
	else
		matb = mata;

	modulus = zm_modulus(cring);
	/*
	 * i represents the row number of matc
	 */
	for (i = 1; i <= am; ++i)
	{
		/*
		 * j represents the column number of matc
		 */
		for (j = 1; j <= bn; ++j)
		{
			/*
			 * Integer modules matrices.
			 */
			s = 0;
			for (k = 1; k <= an; ++k)
			{
				temp1 = s;
				temp2 = modint_mult(modulus, mat_elt(mata, i, k), mat_elt(matb, k, j));
				s = modint_add(modulus, temp1, temp2);
				integer_delref( temp1 );
				integer_delref( temp2 );
			}
			mat_elt(matc, i, j) = s;
		}
	}
	mat_create_result(cring, respack, *pc, matc);
	mat_free_unpkd(a, mata);
	/*
	 * Free only if a and b were different
	 */
	if (a != b)
		mat_free_unpkd(b, matb);

	return;
}


matrix 
mat_zm_mult WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
)
/*
** Returns a * b, a and b matrices over integer module cring.
*/
{
	matrix c = 0;
	mat_zm_mult_sub(cring, a, b, &c);
	return c;
}

