#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"
#include "error.e"

t_poly
modpoly_resultant WITH_4_ARGS(
    t_handle,       pring,
    t_int,  pdig,
    t_poly,      apoly,
    t_poly,      bpoly
)
/*
** MODPOLY_RESULTANT:  modular polynomial resultant.
** pdig is a PRIME small integer
** apoly, bpoly are polynomials over Zpdig of positive degree,
** returns : resultant of apoly and bpoly
*/
{
    block_declarations;
    t_handle           aph;        /* apoly t_handle */
    t_handle           bph;        /* bpoly t_handle */
    t_handle           dsh;        /* dstar t_handle */
    t_poly        acoefft;
    t_poly        cpoly;
    t_poly        dpoly;
    t_poly        tpoly;        /* temporary poly */
    t_poly        astar;
    t_poly        bstar;
    t_poly        cstar;
    t_poly        dstar;
    t_poly        b;
    t_int    i;
    t_int     lpvar;
    t_int    m, m1, n, n1, k;

    if (!integer_is_single (pdig))
    {
        error_internal ("can not perform resultant modulus big_int\n");
    }

    /* assumes that both polynomials non_constant */

    bph = m_poly_poly_to_handle( bpoly );
    aph = m_poly_poly_to_handle( apoly );

    if (m_poly_univariate(aph) || m_poly_univariate(bph))
    {
#if 0
        cay_print("Univariate.  Calling poly_u_zm_resultant\n");
#endif
#ifdef DEBUG
        if (!m_poly_univariate(aph) || !m_poly_univariate(bph))
        {
            error_internal ("modpoly_resultant: polys not lifted\n");
        }
#endif /* DEBUG */
        return (poly_u_zm_resultant (pring, pdig, apoly, bpoly));
    }

    /* set r to the number of the least principal variable */

    /* Initialize */

    lpvar = m_poly_least_pvar (aph);
    m =  poly_deg( apoly);
    m1 = poly_deg_sp_var (apoly, lpvar);
    n =  poly_deg( bpoly);
    n1 = poly_deg_sp_var (bpoly, lpvar);
    k = m*n1+m1*n;
#if 0
    cay_print("k=%d\n",k);
#endif
    /* assign cpoly the zero poly like the coeffs of apoly */
    acoefft = m_poly_coefft (aph, 0);
    cpoly = poly_z_zero_poly (pring, acoefft);

    /* assign dpoly univariate 1 */
    m_poly_create_empty (&dsh, lpvar, lpvar, 1);
    m_poly_coefft (dsh, 0) = 1;
    m_poly_expt (dsh, 0) = 0;
    dpoly = m_poly_handle_to_poly (dsh);

    /* Recursion */

#if 0
cay_print ("\n", i);
#endif
    for (i=0; i < pdig; i++)
    {
#if 0
cay_print ("%d ", i);
#endif
        astar = modpoly_eval_lpvar (pring, pdig, apoly, i);
        if (poly_deg( astar) == m)
        {
            bstar = modpoly_eval_lpvar (pring, pdig, bpoly, i);
            if (poly_deg( bstar) == n)
            {
                cstar = modpoly_resultant (pring, pdig, astar, bstar);
                b = modpoly_eval_princvar (pring, pdig, dpoly, i);
#ifdef DEBUG
                if (!m_poly_is_small_int(b))
                {
                    error_internal( "puke and die in MPRES" );
                }
#endif /* DEBUG */
                b = modint_invert(pdig,b); /* MDINV(pdig,b) */
                tpoly = cpoly;
#if 0
                cay_print("\nCalling modpoly_interpolate\n\tp = %d   i = %d   b = %d\n\tdpoly = ",pdig, i, b);
                poly_z_write (pring, dpoly);
                cay_print("\n\tcpoly = ");
                poly_z_write (pring, cpoly);
                cay_print("\n\tcstar = ");
                poly_z_write (pring, cstar);
                cay_print("\n");
#endif
                cpoly = modpoly_interpolate
                              (pring, pdig, dpoly, i, b, cpoly, cstar);
#if 0
                cay_print ("RESULT cpoly = ");
                poly_z_write (pring, cpoly);
                cay_print ("\n");
#endif
                m_modpoly_delref( pring, tpoly );
                m_modpoly_delref( pring, cstar );

                /* dstar = (x + p-i) */
                if (i)
                {
                    m_poly_create_empty (&dsh, lpvar, lpvar, 2);
                    m_poly_coefft(dsh,0) = pdig-i;
                    m_poly_coefft(dsh,1) = 1;
                    m_poly_expt(dsh,0) = 0;
                    m_poly_expt(dsh,1) = 1;
                }
                else  /* dstar = x */
                {
                    m_poly_create_empty (&dsh, lpvar, lpvar, 1);
                    m_poly_coefft(dsh,0) = 1;
                    m_poly_expt(dsh,0) = 1;
                }
                dstar = m_poly_handle_to_poly(dsh);
        
                tpoly = dpoly;
                dpoly = modpoly_mult (pring, pdig, dpoly, dstar);
#if 0
                cay_print("dstar = ");
                poly_z_write (pring, dstar);
                cay_print("\ndpoly = ");
                poly_z_write (pring, dpoly);
                cay_print("\n");
#endif
                m_modpoly_delref (pring, tpoly);
                m_modpoly_delref (pring, dstar);
                if (poly_deg( dpoly) > k)
                {
                    m_modpoly_delref( pring, astar );
                    m_modpoly_delref( pring, bstar );
                    m_modpoly_delref( pring, dpoly );
                    return (cpoly);
                }
            }
            m_modpoly_delref( pring, bstar );
        }
        m_modpoly_delref( pring, astar );
    }

    /* Algorithm fails */

    m_modpoly_delref( pring, dpoly );
    error_internal( "Algorithm for modpoly_resultant fails" );
    return 0;
}
                
/*
 *  safe b,m1,n1.
 *  [r=1.]  if r=1 then {C:=MUPRES(p,A,B); return}.
 *  [Initialize.]  m:=FIRST(A); m1:=PDEGSV(r,A,1);
 *  n:=FIRST(B); n1=PDEGSV(r,B,1); k:=m * n1+m1 * n;
 *  r':=r-1; C:=0; D:=LIST2(0,1); i:=0.
 *  [Recursion.]  while i < p do { A*:=MPEVAL(r,p,A,1,i);
 *  if PDEG(A*)=m then {B*:=MPEVAL(r,p,B,1,i);
 *  if PDEG(B*)=n then {C*:=MPRES(r',p,A*,B*); b:=MPEMV(1,p,D,i);
 *  b:=MDINV(p,b); C:=MPINT(p,D,i,b,r',C,C*);
 *  D':=LIST4(1,1,0,p-i); D:=MPPROD(1,p,D,D');
 *  if PDEG(D) > k then return} };  i:=i+1}.
 *  
 *  [Algorithm fails.]  CLOUT("ALGORITHM MPRES FAILS.");
 *  EMPTOB; stop||
 */
