#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
modpoly_uni_quot WITH_4_ARGS(
        t_handle,       pring,
        integer_big,    pdig,
        t_poly,      apoly,
        t_poly,      unipoly
)
/*
** MODPOLY_UNI_QUOT : modular polynomial univariate quotient. ( MPUQ )
** pdig: prime integer.
** apoly: a polynomial over Zpdig.
** unipoly:a non-zero univariate polynomial over Zpdig, and unipoly
**    divides apoly.
** Returns: respoly = apoly/unipoly.
*/
{
    t_poly        respoly;
    t_handle           resh;
    t_handle           aph;
    t_int    aterms;
    t_int    termno;
    t_poly        acoefft;

    aph = m_poly_poly_to_handle( apoly );
    aterms = m_poly_nterms( aph );
    m_poly_create_empty (&resh, m_poly_princvar (aph),
                                        m_poly_least_pvar (aph), aterms);
    respoly = m_poly_handle_to_poly (resh);
    acoefft = m_poly_coefft( aph, 0 );

    if (m_poly_univariate (m_poly_poly_to_handle (acoefft)))
    {
        for (termno = 0; termno < aterms; )
        {
            m_poly_expt (resh, termno) = m_poly_expt (aph, termno);
            m_poly_coefft (resh, termno) =
                          modpoly_div (pring, pdig, acoefft, unipoly);
            termno ++;
            acoefft = m_poly_coefft( aph, termno );
        }
    }
    else
    {
        for (termno = 0; termno < aterms; )
        {
            m_poly_expt (resh, termno) = m_poly_expt (aph, termno);
            m_poly_coefft (resh, termno) =
                      modpoly_uni_quot (pring, pdig, acoefft, unipoly);
            termno ++;
            acoefft = m_poly_coefft( aph, termno );
        }
    }

    return poly_z_clean (pring, respoly);
}
