#define MP_DEFINITIONS
 
#include "defs.h"
#include "mp.e"
#include "mp.h"
 
 
 
 
/******************************************************************************
                        INITIALIZATION FUNCTIONS
******************************************************************************/
 
 
void
mp_priv_reset()
/*
Resets the mp package (at initialization or after an error).
*/  
/* t_mem_word zuruechgesetzt auf t-word */
{
    mp_acc_sp = sizeof(t_word) * BLOCK_HEADER_WORDS;
    mp_priv_change_flag = 0;
    mp_priv_change_mask = 1;
 
#ifndef NO_DEBUG
    mp_priv_indent = 0;
#endif
}
 
 
 
void
mp_start WITH_2_ARGS(
        mp_round_type,  r,
        void_func,      callback /*(char *)*/
)
/*
Initializes the mp package and sets the internal rounding type to r.
The mp callback function is set to the parameter callback.  This function will
be called with a string containing a message when an error occurs.
*/
{
#ifdef MP_USE_RECALL
    extern mp_int       mp_pi_precise_len;
    extern mp_int       mp_catalan_precise_len;
    extern mp_int       mp_eul_precise_len;
#endif MP_USE_RECALL
 
    round = r;
    mp_callback = callback;
 
    /*
    Initialize the accumulator.
    */
 
    mp_accum = mem_alloc_words_zero(digit_to_int(ACC_SIZE));
 
    mp_reset();
 
    min_expt = MAX_EXPT + 1;
    max_expt = -MAX_EXPT;
    num_unfl = 0;
 
#ifdef MP_USE_RECALL
    mp_pi_precise_len = -1;
    mp_catalan_precise_len = -1;
    mp_eul_precise_len = -1;
#endif MP_USE_RECALL
}
 
 
 
void
mp_finish()
/*
Deallocates any temporary space used by the mp package - should be called
when the user is finished with the package.
*/
{
    mem_delete_hptr(&mp_accum);
}
 
 
 
 
/******************************************************************************
                            FLOAT OPERATIONS
******************************************************************************/
 
 
mp_float f_mp_alloc MEM_DECL_2(b, t)
mp_base_type    b;
mp_length       t;
/*
Returns an allocated mp_float with its internal base set to b, and the
number of digits to be held in it set to t.
*/
{
    mp_float            z;
    mp_ptr_type         zp;
 
    z = mem_alloc_words_zero_INHERIT(mp_size(t));
    block_init(z, MP_BLOCK_TYPE);
    zp = mp_ptr(z);
 
    mp_b(zp) = b;
    mp_t(zp) = t;
    mp_set_sign(zp, 0);
 
    DEBUG_BEGIN(DEBUG_BH);
    DEBUG_PRINTF_1("+alloc {\n");
    DEBUG_PRINTF_3("b = %d, t = %d\n", b, t);
    DEBUG_PRINTF_2("-} h = %d\n", h);
    DEBUG_END();
    
    return z;
}
 
 
 
void
mp_delete_float WITH_1_ARG(
        mp_float,       z
)
/*
Deletes the float z.
*/
{
    block_decref_delete(z);
}
 
 
 
 
/******************************************************************************
                        ARRAY OPERATIONS
******************************************************************************/
 
 
mp_float_array
mp_float_array_alloc    WITH_3_ARGS(
        mp_int,         dim,
        mp_base_type,   b,
        mp_length,      t
)
/*
Returns an allocated mp_float_array with room for dim (float) elements, each of
which having its internal base set to b, and the number of digits to be held
in it set to t.
*/
{
    mp_float_array      h;
    mp_float_array_hdr  *a;
    mp_float            *bp;
 
    ASSERT(dim >= 0);
 
    h = mem_alloc_words_zero(MP_ARRAY_HDR_LEN + dim);
    block_init(h, MP_ARRAY_BLOCK_TYPE);
 
    a = ((mp_float_array_hdr *)mem_access(h));
    a->mp_arr_dim = dim;
 
    while (dim-- > 0)
        mp_array_element(h, dim) = mp_alloc(b, t);
 
    return h;
}
 
 
 
#if 0
mp_float
mp_array_element        WITH_2_ARGS(
        mp_float_array,         a,
        mp_int,                 i
)
/*
Returns the i'th element of the array a (origin 0).
*/
{
    mp_float    z;
 
    z.mp_flt_handle = a;
    z.mp_flt_offset = MP_ARRAY_HDR_LEN + i *
                        ((mp_float_array_hdr *)mem_access(a))->mp_arr_el_size;
    
    return z;
}
#endif
 
 
 
void
mp_delete_float_array   WITH_1_ARG(
        mp_float_array,         a
)
/*
Decrements the reference count of the float array a.
*/
{
    mp_float_array_hdr  *ap;
    mp_float            *bp;
    t_int               dim;
 
    if (block_has_other_refs(a))
    {
        block_decref_delete(a);
        return;
    }
 
    ap = ((mp_float_array_hdr *)mem_access(a));
    dim = ap->mp_arr_dim;
 
    while (dim-- > 0)
        mp_delete_float(mp_array_element(a, dim));
 
    mem_delete_h(a);
}
 
 
 
 
 
 
 
/******************************************************************************
                MISCELLANEOUS FUNCTIONS USED BY THE MP FUNCTIONS
******************************************************************************/
 
 
void
mp_priv_shift_r         WITH_3_ARGS(
        mp_digit_ptr_type,      p,
        mp_length,              off,
        mp_length,              n
)
/*
Shifts n digits starting at p right off places.
*/
{
    while (n-- > 0)
        p[n + off] = p[n];
}
 
 
void
mp_priv_shift_l         WITH_3_ARGS(
        mp_digit_ptr_type,      p,
        mp_length,              off,
        mp_length,              n
)
/*
Shifts n digits starting at p left off places.
*/
{
    while (n-- > 0)
    {
        p[-off] = p[0];
        p++;
    }
}
 
 
mp_int
mp_priv_all_zero        WITH_2_ARGS(
        mp_digit_ptr_type,      p,
        mp_length,              n
)
/*
Returns whether p[0..n-1] are all zero.
*/
{
    while (n-- > 0)
        if (p[n])
            return FALSE;
    
    return TRUE;
}
                
 
 
mp_int
mp_priv_comp_digits     WITH_2_ARGS(
        mp_ptr_type,    x,
        mp_ptr_type,    y
)
/*
Returns -1, 0, 1 according to whether the digits of x <, ==, > those of y.
x and y are mp pointers.
*/
{
    mp_length           i, t;
    mp_digit_ptr_type   xp = mp_digit_ptr(x, 0),
                        yp = mp_digit_ptr(y, 0);
 
    t = mp_t(x);
 
    for (i = 0; i < t; i++)
        if (xp[i] < yp[i])
            return -1;
        else if (xp[i] > yp[i])
            return 1;
 
    return 0;
}
 
 
 
void
mp_priv_copy            WITH_2_ARGS(
        mp_float,       x,
        mp_float,       y
)
/*
Copies the mp number x to y.
*/
{
    DEBUG_BEGIN(DEBUG_BH);
 
    DEBUG_PRINTF_1("+copy {\n");
    DEBUG_1("x = ", mp_ptr(x));
 
    mp_copy_ptr(mp_ptr(x), mp_ptr(y));
 
    DEBUG_1("-} y = ", mp_ptr(y));
    DEBUG_END();
}
 
mp_underflow() { mp_error("real underflow");}
mp_overflow() { mp_error("real overflow");}
 
