#include "defs.h"
#include "mp.e"
#include "mp.h"


mp_float
mp_priv_scale	WITH_3_ARGS(
	mp_float,	x,
	mp_base_type,	base,
	mp_int,		j
)
/*
Sets x *= base^j and returns x.  Accumulator operations are performed.
*/
{
    mp_ptr_type		xp = mp_ptr(x);

    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+scale {\n");
    DEBUG_1("x = ", xp);
    DEBUG_PRINTF_3("base = %d, j = %d\n\n", base, j);

    if (base <= 1)
	mp_bug("mp_scale: illegal base");

    if (j && !mp_is_zero(xp))
    {
	/*
	The following numbers were determined empirically for base = 10.
	The optimum choice depends on base, b, and t (of x).
	*/

	if (j <= -500 || j >= 100)
	{
	    mp_acc_float	temp;
	    mp_round_type	save_round = round;

	    /*
	    Here the exponent is large, so use mp_abs_int_power() to compute
	    base ^ int_abs(j).
	    */

	    round = mp_fix_directed(mp_sign(xp), round);

	    mp_acc_float_alloc(mp_b(xp), mp_t(xp), temp);
	    mp_int_to_mp(base, temp);

	    mp_abs_int_power(temp, int_abs(j), temp);

	    if (j < 0)
		mp_div_eq(x, temp);

	    else
		mp_mul_eq(x, temp);

	    round = save_round;
	    mp_acc_float_delete(temp);
	}
	else
	{
	    /*
	    Here int_abs(j) is small so it is probably faster to use
	    mp_mul_int() or mp_div_int().
	    */

	    mp_base_type	b = mp_b(xp);
	    mp_int		i, multiplier = 1, abs_j = int_abs(j),
				limit = MAX_INT / base;


	    for (i = 1; i <= abs_j; i++)
	    {
		multiplier *= base;
		if (multiplier > limit || multiplier == b || i >= abs_j)
		{
		    if (j < 0)
			mp_div_int_eq(x, multiplier);

		    else
			mp_mul_int_eq(x, multiplier);

		    multiplier = 1;
		}
	    }
	}
    }

    DEBUG_1("-} x = ", mp_ptr(x));

    DEBUG_END();
    return x;
}
