#ifdef KANT
#include "defs.h"
#include "error.e"
#include "debug.e"
#include "structure.e"
#include "system.h"
#include "mp.e"
#include <stdio.h>

void cay_varargs P_((t_char *, va_list));
void strng1 P_((char *));
void pchar P_((int));
double absdbl P_((double));

#define integr integer_write


int debug[51]={ /*# 0, #*/
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE,
                        FALSE, FALSE, FALSE, FALSE, FALSE, };


/*
 *      The new debug flags.
 *      The bottom 51 entries of this array are never used because
 *      indexes 1 .. 51 go to the df array and not to this array.
 *      51 is some special shpr value - see command.c.
 */

public t_logical debug_flags[ DEBUG_NUM_FLAGS ];



#define TYPEMAX 31
static char	*cay_type_names[] =
{
	"",
	"Logical",
	"Integer",
	"Ring or Field Elt",
	"Group Elt",
	"Group",
	"Ye olde Representation",
	"Relation Chain",
	"Word",
	"Ring or Field",
	"Coset Table",
	"Module",
	"Set",
	"Sequence",
	"Cyclotomic Number",
	"Empty Set",
	"Map",
	"Module Elt",
	"Character",
	"",
	"File",
	"Text String",
	"Structured Sequence",
	"",
	"",
	"",
	"Graph",
	"Vertex",
	"Edge",
	"Rational Number",
	"Character Table",
	"Polynomial",
};
 

Void
print_float(x, m, n)
t_float	x;
Int	m;
Int	n;
{
	register Int	i1;
	register Int	i2;
	register Int	i3;
	register t_float	xx2;
	register Int	ndig;

	/*
	 * write x in fm.n format ( or something similar )
	 */

	i1 = (Int) x;
	if ( i1 == 0 && x < 0.0 )
	{
		strng1( "-" );
	}
	integr(i1, -(m - (n + 1)));
	strng1(".");
	xx2 = absdbl(x - ((t_float) i1));
	ndig = int_min(n, 9);
	i2 = (Int) (((t_float) power(10, ndig)) * xx2);
	i3 = idig(i2);
	for (i1 = i3; i1 < ndig; i1++)
		strng1("0");
	integr(i2, i3);
	for (i1 = ndig; i1 < n; i1++)
		strng1("0");
}
 
void
cay_print VARARGS_DECL((t_char *messlist, ...))
{
	/*
	 *	This routine implements printf for Cayley.
	 *	The first argument must be the format string.
	 *	Format characters are preceded by a '%' character
	 *	and the possibities for formatting are:
	 *		d	- 	single or infinite-precision integer
	 *		s	- 	string
	 *		f	-	floating point
	 *		i	-	identifier (id number)
	 *		t	-	type (type number)
	 *		l	-	machine integer
	 *	Any other characters following the '%' are simply printed.
	 *
	 *	Field widths are not accepted.  Integers are printed in
	 *	the width required and Floating points are printed with
	 *	three decimal places and the width required.
	 */
	va_list          args;
        VARARGS_LOCALS(t_char *messlist;)
 
        VARARGS_START(args, t_char *, messlist);
	cay_varargs(messlist, args);
	va_end(args);
}

void
cay_varargs(messlist, args)
char *messlist;
va_list args;
{
	char	*format;
	char	ch;
	int	intarg;
	char	*strarg;
	float	floatarg;

	ASSERT(messlist);
	format = messlist;
	for (; (ch = *format) != '\0'; format++)
	{
		if (ch != '%')
			pchar(ch);
		else
		{
			ch = *(++format);
			if (ch == '\0')
			{
				strng1("%");
				break;
			}

			switch (ch)
			{
			case 'd':
			case 'i':
				intarg = va_arg(args, int);
				integer_write(intarg, 0);
				break;

			case 's':
				strarg = va_arg(args, char *);
				strng1(strarg);
				break;

			case 'f':
				floatarg = va_arg(args, double);
				print_float(floatarg, 4, 3);
				break;

			case 't':
				intarg = va_arg(args, int);
				if (intarg > 0 && intarg <= TYPEMAX)
					strng1(cay_type_names[intarg]);
				else
					integer_write(intarg, 0);
				break;

			case 'l':
				intarg = va_arg(args, int);
				integr(intarg, 0);
				break;

			default:
				pchar(ch);
				break;
			}
		}
	}
}

print_var()
{ DIE(); }
/*
 *      Buffer for all the print routines
 */
 
private t_char  buffer[2000];

/*
 *      Fatal errors.
 *      These cause Cayley to exit.
 *      Because these may occur before the io system is initialised
 *      (eg: when loading the user environment, or allocing workspace)
 *      this routine uses fprintf( stderr.. )
 */

public t_int
error_fatal VARARGS_DECL((t_char *fmt, ...))
{
        va_list          args;
        VARARGS_LOCALS(t_char *fmt;)

        fprintf(stderr, "Fatal Error : ");
        VARARGS_START(args, t_char *, fmt);
        vsprintf(buffer, fmt, args);
        fprintf(stderr, "%s\n", buffer);
        va_end(args);
        fflush(stderr);
        exit(1);
}

public t_int 
error_runtime VARARGS_DECL((t_int error_num, ...))
{
     VARARGS_LOCALS(t_int error_num;)
     error_internal("Runtime error # : %s", error_num);
}


public t_void f_assert(x, file, num, expr)
t_int   x, num;
t_char  *file, *expr;
{
    if( !x )
    {
                error_internal( "assertion %s failed: file %s, line %d\n",
                        expr, file, num);
    }
}


t_void
error_die(s, n)
t_char           *s;
t_int              n;
{
        error_internal("die at %s, line %d", s, n);
}        
 
/*
 *      Internal run-time errors.
 */


public t_int
error_internal VARARGS_DECL((t_char *fmt, ...))
{
        va_list          args;
        VARARGS_LOCALS(t_char *fmt;)
        t_int              dummy;
        static t_int    count;

        cay_print("\n");
        cay_print("\nThis is a bug:\n");
        VARARGS_START(args, t_char *, fmt);
        vsprintf(buffer, fmt, args);
        cay_print(buffer);
	va_end(args);
        cay_print("\n");
	error_fatal("You should have got a trace back - lazy programmer.");
}
 


void
strng1(text)
char	*text;
{
	Char	*s;

	for (s = text; *s != '\0'; s++)
		pchar(*s);
}


Int
idig(arg)
Int	arg;
{
	register Int	j, digits;

	/*
	 * Find the number of decimal digits needed to print arg
	 */

	j = arg < 0 ? -arg : arg;
	for (digits = 1; j > 9; j /= 10, digits++)
		;
	return digits;
}



#define FF      (12)
#define LF      '\n'
#define CR      (13)

extern Int      print[];
extern Int      run[];

#define chno    (print[1])
#define lempty  (*(Logical *)&print[5])
#define line    (&print[6 - 1])
#define linlim  (run[5])

void
pchar WITH_1_ARG(
	int,	c
)
{
	putchar( c );
}    
 
Void dmplin()
{
	puts("");
}    


#if 0

Void
pchar(letter)
Int     letter;
{

        /*
         * print character letter on the output line
         * the synonym char is widely used for pchar for historical reasons, but         * pchar should eventually replace it as the name char causes problems to
         * some fortran compilers
         * the following is coded for speed rather than elegance
         */
        ARITHMETIC_IF(letter - CR, L10, L20, L30)

L10:    if (letter == FF)
        {
                return;
	}
        else if (letter != LF)
                goto L30;
 
L20:    dmplin();
        return;
 
L30:    if (chno >= linlim)
                endlin();
 
        chno = chno + 1;
        line[chno] = letter;
        lempty = FALSE;
 
        return;
}

#endif /* 0 */

public t_int structure_repnum(s) 
t_handle s; 
{ return m_structure_repnum(s); } 

/*  changed by MJ due a mail from allan 
void callback( code, msg )
int     code;
char    *msg;
{
        printf( "\n code = %d\n%s", code, msg );
}
*/

void callback(t)
int t;
{
    abort();
}
 
      

int
max(x, y)
int	x;
int	y;
{
	return (y > x) ? y : x;
}
t_int int_min(a, b)
t_int     a, b;
{
    return a < b? a: b;
}

t_int int_max(a, b)
t_int     a, b;
{
    return a > b? a: b;
}
 
t_int int_abs(a)
t_int     a;
{
    return a < 0? -a: a;
}
 
double
absdbl(x)
double x;
{
	return (x < 0) ? -x : x;
}
power(x, y)
register int	x;
register int	y;
{
	register int c;

	if (x == 0 && y == 0)
		error_internal("0^0 is not defined");
	c = 1;
	for (;;)
	{
		switch (y)
		{
		case 0:
			return c;

		case 1:
			return c * x;

		default:
			if (y % 2 == 1)
				c = c * x;
			x = x * x;
			y = y / 2;
		}
	}
}



integer_small small_primes[ NSPRIMES ]={ 
			  2,   3,   5,   7,  11,
			 13,  17,  19,  23,  29,
			 31,  37,  41,  43,  47,
			 53,  59,  61,  67,  71,
			 73,  79,  83,  89,  97,
			101, 103, 107, 109, 113,
			127, 131, 137, 139, 149,
			151, 157, 163, 167, 173,
			179, 181, 191, 193, 197,
			199, 211, 223, 227, 229,
			233, 239, 241, 251, 257,
			263, 269, 271, 277, 281,
			283, 293, 307, 311, 313,
			317, 331, 337, 347, 349,
			353, 359, 367, 373, 379,
			383, 389, 397, 401, 409,
			419, 421, 431, 433, 439,
			443, 449, 457, 461, 463,
			467, 479, 487, 491, 499,
			503, 509, 521, 523, 541,
			547, 557, 563, 569, 571,
			577, 587, 593, 599, 601,
			607, 613, 617, 619, 631,
			641, 643, 647, 653, 659,
			661, 673, 677, 683, 691,
			701, 709, 719, 727, 733,
			739, 743, 751, 757, 761,
			769, 773, 787, 797, 809,
			811, 821, 823, 827, 829,
			839, 853, 857, 859, 863,
			877, 881, 883, 887, 907,
			911, 919, 929, 937, 941,
			947, 953, 967, 971, 977,
			983, 991, 997
		};


	int iuz[NRESIDUES]={
		       1,  11,  13,  17,  19,
		      23,  29,  31,  37,  41,
		      43,  47,  53,  59,  61,
		      67,  71,  73,  79,  83,
		      89,  97, 101, 103, 107,
		     109, 113, 121, 127, 131,
		     137, 139, 143, 149, 151,
		     157, 163, 167, 169, 173,
		     179, 181, 187, 191, 193,
		     197, 199, 209,
			    };

/*
 *	For use by modular Smith normal form
 */

t_int	primes[] = 
{0,
     44657, 44683, 44687, 44699, 44701, 44711, 44729, 44741, 44753, 44771, 
     44773, 44777, 44789, 44797, 44809, 44819, 44839, 44843, 44851, 44867, 
     44879, 44887, 44893, 44909, 44917, 44927, 44939, 44953, 44959, 44963, 
     44971, 44983, 44987, 45007, 45013, 45053, 45061, 45077, 45083, 45119, 
     45121, 45127, 45131, 45137, 45139, 45161, 45179, 45181, 45191, 45197, 
     45233, 45247, 45259, 45263, 45281, 45289, 45293, 45307, 45317, 45319, 
     45329, 45337, 45341, 45343, 45361, 45377, 45389, 45403, 45413, 45427, 
     45433, 45439, 45481, 45491, 45497, 45503, 45523, 45533, 45541, 45553, 
     45557, 45569, 45587, 45589, 45599, 45613, 45631, 45641, 45659, 45667, 
     45673, 45677, 45691, 45697, 45707, 45737, 45751, 45757, 45763, 45767,
};

	int seed = 1;	/* Random number generator seed */


#endif
