#include "poly.h"

t_poly
poly_ithvar_deriv (pring, apoly, i)
t_handle	pring;
t_poly		apoly;
t_int		i;
/*
*    returns the derivative of apoly with respect to the ith var
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_ithvar_deriv_crf(&context, apoly, i);
}

t_poly
poly_ithvar_deriv_crf(context, apoly, i)
t_poly_ctx	context;
t_poly		apoly;
t_int		i;
{
	t_handle           resph;        /*    t_handle to result polynomial */
	t_int     prvar;        /*    most principal var of apoly */
	t_int     lpvar;        /*    least princ var of apoly    */
	t_int    atermno;      /*    term counter for apoly      */
	t_int    restermno;    /*    term counter for respoly    */
	t_int    nterms;       /*    no. terms in apoly          */
	t_poly        temppoly;     /*    intermediate polynomial     */
	t_poly        respoly;      /*    result polynomial           */

	t_handle	cring;
	t_polyp		ap, resp;


	cring = m_poly_ctx_cring(context);
	

	DENY (m_poly_const( apoly ) );

	/* general case : non-trivial polynomial */
	ap = m_poly_to_ptr(apoly);
	prvar = m_polyp_princvar( ap );
	lpvar = m_polyp_least_pvar( ap );

	if ( (i < prvar) || (i > lpvar) )
	{
		/* poly constant w.r.t. ith var */
		return( poly_zero_poly_crf (context, apoly));
	}

	if ( i == prvar )
	{
		/* i is the principal variable of apoly */
		return  poly_deriv_princvar_crf( context, apoly );
	}
	/* At this stage, the polynomial should not be univariate. */
	DENY(m_polyp_univariate(ap));

	/* i > m_polyp_princvar( ap )    */

	nterms = m_polyp_nterms( ap );
	m_poly_create_empty(&resph, prvar, lpvar, nterms );
	resp = m_poly_hdl_to_ptr( resph );
	respoly = m_poly_handle_to_poly(resph);

	for ( atermno = 0, restermno = 0; atermno < nterms; atermno++ )
	{
		/* take ith derivative of each term */
		temppoly = poly_ithvar_deriv_crf( context, m_polyp_coefft( ap, atermno ), i );

		m_polyp_coefft( resp, restermno ) = temppoly;
		m_polyp_expt( resp, restermno ) = m_polyp_expt( ap, atermno );
		restermno++;
	}

	m_polyp_nterms( resp ) = restermno;
	return  poly_clean_crf(context, respoly );
}



t_poly
poly_deriv_princvar (pring, apoly)
t_handle	pring;
t_poly		apoly;
/*
*    Derivative w.r.t. principal variable
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_deriv_princvar_crf(&context, apoly);
}

t_poly
poly_deriv_princvar_crf (context, apoly)
t_poly_ctx	context;
t_poly		apoly;
{
	t_handle           resph;        /*    t_handle to respoly        */
	t_poly        respoly;   /*  result polynomial       */
	t_poly        coefft;
	t_poly        temp;
	t_int    expt;
	t_int    nterms;    /*    no. terms in apolt        */
	t_int    termno;    /*    term i for apoly        */
	t_int    restermno;    /*    term i for respoly        */
	t_int	univ;

	t_handle	cring;
	t_pfh		elt_mult;
	t_polyp		ap;
	t_polyp		resp;
	t_handle	tmp_expt;
	t_int		it;
	
	cring = m_poly_ctx_cring(context);
	elt_mult = m_poly_ctx_elt_mult(context);

	DENY ( m_poly_const( apoly ) );

	ap = m_poly_to_ptr( apoly );
	nterms = m_polyp_nterms( ap );

	if ( ( nterms == 0 ) || ( poly_deg( apoly ) == 0 ) )
	{
		return(poly_zero_poly_crf(context, apoly));
	}

	/* not constant in main variable */

	m_poly_create_empty(&resph, m_polyp_princvar(ap),
                                    m_polyp_least_pvar(ap), nterms );
	respoly = m_poly_handle_to_poly( resph );
	resp = m_poly_hdl_to_ptr(resph);
    
	univ = m_polyp_univariate(ap);
	for ( restermno = 0, termno = 0; termno < nterms; termno++ )
	{
		coefft = m_polyp_coefft( ap, termno );
		expt = m_polyp_expt( ap, termno );

		if ( expt != 0 )    /* ignore terms with expt == 0 */
		{
			/* multiply coefficient by exponent */
			tmp_expt = poly_z_embed_crf(context, expt);
			if ( univ )
			{
				(*elt_mult)(cring, coefft, 0, tmp_expt, 0, &temp, &it );
			}
			else
			{
				temp = poly_scalar_mult_crf( context, coefft, tmp_expt );
			}

			m_polyp_coefft( resp, restermno ) = temp;
			m_polyp_expt( resp, restermno ) = expt - 1;

			restermno++;
		}
	}

	m_polyp_nterms( resp ) = restermno;
	return  poly_clean_crf( context, respoly );

}


t_poly
poly_high_deriv_princvar (pring, apoly, k)
t_handle	pring;
t_poly		apoly;
t_int		k;
/*
*    Polynomial higher derivative
*    k is a non-negative beta-digit
*    Returns k-th derivative of apoly w.r.t. main var, as a poly.
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_high_deriv_princvar_crf(&context, apoly, k);
}

t_poly
poly_high_deriv_princvar_crf(context, apoly, k)
t_poly_ctx	context;
t_poly		apoly;
t_int		k;
{
	t_int		i;          /*    loop counter        */
	t_poly		respoly;    /*    result polynomial    */
	t_poly		temp;
	t_handle	cring;


	cring = m_poly_ctx_cring(context);

	if (poly_deg(apoly) < k)
	{
		return (poly_zero_poly_crf (context, apoly));
	}
	respoly = poly_elt_incref_crf(context, apoly );

	for (i = k; i > 0; i--)
	{
		/* continually take derivative until kth derivative */
		temp = respoly;
		respoly = poly_deriv_princvar_crf(context, temp );
		poly_elt_delete_crf( context, &temp );
	}
	return  respoly;
}


t_poly
poly_high_deriv_ith_var (pring, apoly, k, i )
t_handle	pring;
t_poly		apoly;
t_int		k;
t_int		i;
/*
*    polynomial higher derivative ith variable.
*    k is a non-negative beta-digit
*    Returns k-th derivative of apoly w.r.t. ith var, as a poly.
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_high_deriv_ith_var_crf(&context, apoly, k, i);
}

t_poly
poly_high_deriv_ith_var_crf (context, apoly, k, i )
t_poly_ctx      context;
t_poly          apoly;
t_int           k;
t_int           i;
{
	t_int		j;            /*    loop counter        */
	t_poly		respoly;    /*    result polynomial    */
	t_poly		temp;

	respoly = poly_elt_incref_crf(context, apoly );

	for (j = k; j > 0; j--)
	{
		/* continually take derivative until kth derivative */

		temp = respoly;
		respoly = poly_ithvar_deriv_crf(context, temp, i );
		poly_elt_delete_crf(context, &temp );
	}
	return  respoly;
} 


