#include "defs.h"
#include "poly.h"
#include "ring.h"
#include "gen_ring.h"
#ifndef KANT
#include "alg.e"
#endif 

t_void
poly_init_context(pring, context)
t_handle	pring;
t_poly_ctx		context;
{
	t_handle	cring;
	
	cring =  m_poly_coeff_ring(pring);
	m_poly_ctx_cring(context) = cring;
	/* Note this is a refcnt problem as consts are never deleted! */
	/* Maybe store them in primitives. */
	context->gprim_fns = gen_ring_init_gprim_fns(cring);
	if (ring_is_quotient(pring))
	{
		m_poly_ctx_quotient(context) = TRUE;
		m_poly_ctx_ideal(context) = m_ring_ideal(pring);
	}
	else
	{
		m_poly_ctx_quotient(context) = FALSE;
		m_poly_ctx_ideal(context) = NULL_HANDLE;
	}
	return;
}


