
#include "defs.h"
#include "bit_vector.h"
#include "poly_z_faclst.h" 
#include "dyn_arr.h"
#include "integer.e"
#include "poly.h"
#include "debug.e"
#include "error.e"



/*
** IUPFDS in SAC code.
*/

extern	t_int small_primes[];

/* 
** A_poly is a non-zero, squarefree integral univariate polynomial.
** C_set is the intersection of the factor degree sets for factorisations
** of A_poly over Zp for NPFDS primes.
** p is the least prime which gives the smallest number of factors and
** F_list is the distinct degree factorisation of A_poly over Zp. 
*/

t_void
poly_u_z_fact_deg_set WITH_6_ARGS(
t_handle, 		pring,
t_poly,		A_poly,
t_int *,	p,
t_handle *,		F_list,
t_bit_vector *, 	C_set,
t_int,		num_primes
)
{
	t_int	NPFDS;
	t_int	deg, n; 
	integer_big 	a;

	t_bit_vector	I_set, D_set, temp_set;
	t_int	x;
	t_poly	B_poly, B_dash, gcd_poly;
	
	t_int	i, num_succ;
	t_int	r;
	t_int	g_ptr;


	t_handle	G_list, L_part;
	t_int	len;
	t_poly	b;
	t_int	c,f,j, k;


	/* Step 1 : Initialise */
	NPFDS = num_primes; 
	/* This is the number of primes which must be successful. */

	deg = n = poly_deg( A_poly);
	*p = 0;
	a = poly_z_lbase_coefft (pring, A_poly);

	/* Factor set for trivial factorisation */
	I_set = bit_vector_create(n+1);
	bv_bit_set(I_set, 0);
	bv_bit_set(I_set, n);

	n++;
	*C_set = bit_vector_create(n);
	for (x = 0; x < n ; x++)
	{
		bv_bit_set(*C_set, x);
	}
	/*  I_set = [10 ..... 01] 
	** *C_set = [11 ..... 11] (N+1 of them for poly deg = N) 
	** intersection of all possible degrees of factors. 
	** if  any particular degree is not the degree of 
	** a factor mod some prime, then it is not the 
	** degree of a factor over Z[x]
	*/

	B_poly = 0;
	B_dash = 0;
	gcd_poly = 0;
	*F_list = 0;

	/* Step 2 : Try Primes */
	i = num_succ = 0;
	/* i - number of prime in SMPRMS
	** num_succ - number of successful primes
	*/
	while (!bit_vector_equal(*C_set, I_set) && (num_succ < NPFDS))
	{
		IF_DEBUG_FLAG(DEBUG_POLY,
		{
			cay_print("At beginning of while loop C_set = \n");
			bit_vector_print(*C_set);
			cay_print("p = %d \n", *p);
			cay_print("r = %d \n", r);
		}
		);

		if (i == NSPRIMES)
		{
			if (*p)
				goto fin;
			error_internal("Ran out of primes");
		}

		r = small_primes[i];
		i++;
		if (integer_rem(a, r))
		{
			IF_DEBUG_FLAG(DEBUG_POLY,
				cay_print("\t r = %d doesn't divide a = %d.\n", r, a);
			);
			poly_z_elt_delete(pring, &B_poly);
			B_poly = modpoly_hom(pring, r, A_poly);
			IF_DEBUG_FLAG(DEBUG_POLY,
			{
				cay_print("\t B_poly in Z_%d is ...\n", r);
				poly_z_write(pring, B_poly);
			}
			);

			poly_z_elt_delete(pring, &B_dash);
			B_dash = poly_u_zm_deriv(pring, r, B_poly);
			IF_DEBUG_FLAG(DEBUG_POLY,
			{
				cay_print("\t B_dash in Z_%d is ...\n", r);
				poly_z_write(pring, B_dash);
			}
			);


			poly_z_elt_delete(pring, &gcd_poly);
			gcd_poly = poly_u_zm_gcd(pring,r, B_poly, B_dash);
			IF_DEBUG_FLAG(DEBUG_POLY,
			{
				cay_print("\t gcd(B_poly, B_dash )in Z_%d is ...\n", r);
				poly_z_write(pring, gcd_poly);
			}
			);


			if (poly_z_is_one_poly(pring, gcd_poly))
			{
				poly_z_elt_delete(pring, &B_dash);
				B_dash = modpoly_monic(pring, r, B_poly);

				/* There's no need to delete G_list. */
				G_list = poly_u_zm_dist_deg_fact(pring, r, B_dash);
				IF_DEBUG_FLAG(DEBUG_POLY,
				{
					cay_print("\t \t The distinct degree factorization of B_dash in Z_%d is \n", r);
					poly_z_faclst_write(pring, G_list);
				}
				);
				L_part = poly_array_alloc(deg);

				k = 0;
				len = m_poly_z_faclst_len(G_list);
				for (g_ptr = 0; g_ptr < len; g_ptr++ )
				{
					/* b is the product of all irreducible factors
					** of A_poly of degree f
					** Don't delete.
					*/
					b = m_poly_z_faclst_factor(G_list, g_ptr);
					f = m_poly_z_faclst_power(G_list, g_ptr);
					c = poly_deg( b);
					j = c/f; /* # irred factors deg f */
					k += j;

					for( x=1; x<=j; x++)
						poly_array_append(L_part, f);

					/* We want the possible degree set whether or not
					** it is smallest - it will still restrict the possible
					** factors (partitions of deg are a partial order not a 
					** total order.)
					*/
				}
				IF_DEBUG_FLAG(DEBUG_POLY,
				{
					cay_print("\t \t The partition of the degree of the polynomial %d corresponding to this \
					factorisation is ...\n");
					poly_array_write(pring, L_part);
				}
				);
				if (k<n)
				{
				IF_DEBUG_FLAG(DEBUG_POLY,
					cay_print("\t \t \t The total number of factors %d is less than prev minimum %d\n", k, n);
				);

					*p = r;
					n = k;
					if (*F_list)
						poly_z_faclst_delete(pring, F_list);
					*F_list = G_list;
				}
				else
					poly_z_faclst_delete(pring, &G_list);



				D_set = partition_to_set(L_part);
				IF_DEBUG_FLAG(DEBUG_POLY,
				{
					cay_print("\t\t This partition gives rise to the possible degrees ... \n");
					bit_vector_print(D_set);
				}
				);

				poly_array_delete(pring, &L_part);
				temp_set = *C_set;


				*C_set = bit_vector_AND(temp_set, D_set);
				if (temp_set)
					bit_vector_delete(&temp_set);


				bit_vector_delete(&D_set);
				IF_DEBUG_FLAG(DEBUG_POLY,
				{
					cay_print("\t \t The new possible degrees are therefore .. \n");
					bit_vector_print(*C_set);
				}
				);

				num_succ++;


				IF_DEBUG_FLAG(DEBUG_POLY,
				cay_print("The number of successful primes is %d\n", num_succ);
				);
			}

		}

	
	}
	if (bit_vector_equal(*C_set, I_set))
	{
		*p = 0 ;
		if (*F_list)
			poly_z_faclst_delete(pring, F_list);
		*F_list = 0;
		/* The polynomial is irreducible. */
	}

fin:

	bit_vector_delete(&I_set);
	poly_z_elt_delete(pring, &B_dash);
	poly_z_elt_delete(pring, &B_poly);
	poly_z_elt_delete(pring, &gcd_poly);
	return;
}
