#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"


t_poly 
poly_u_z_trunc_mult(pring, n, apoly, bpoly)
t_handle 	pring;
t_int	n;
t_poly	apoly, bpoly;
/*
** This function is IUPTPR in the SAC code.
** Given apoly(x), bpoly(x) in pring, calculate 
** apoly(x)*bpoly(x) (mod x^nl).
**
** We assume that apoly and bpoly are clean polynomials
** and the result will be cleaned before return.
** Assume also that both polynomials are in the same ring.
** Otherwise we may have the case that one is a polynomial 
** and the other is an integer. The problem is that 
** integers cannot be treated as a polynomial because 
** when you convert the polynomial to a handle, 
** you don't know whether you have a handle to a big_integer
** or a small integer, or a polynomial.
*/
{
	block_declarations;
	t_handle		aph, bph, tempph;
	t_poly		addtemp, temp, respoly;
	t_int		anterms, bnterms, i, j;
	t_int		a_exp, b_exp;
	integer_big		a, b;

	/* Check for trivial case. */
	if (!n || poly_z_is_zero_poly(pring, apoly) 
			||poly_z_is_zero_poly(pring, bpoly))
		return poly_z_zero_poly(pring, apoly);	

	/* Now, n>= 1 : check constant. */
	if (m_poly_const(apoly) && m_poly_const(bpoly))
		return (integer_mult(apoly, bpoly));

	/* Now we have that both polynomials are of
	** Z[x] for some x.
	*/
	aph = m_poly_poly_to_handle( apoly );
	bph = m_poly_poly_to_handle( bpoly );

	anterms = m_poly_nterms( aph );
	bnterms = m_poly_nterms( bph );

	if (!m_poly_univariate(aph) || !m_poly_univariate(bph))
		error_internal("Expecting clean univariate poly");
	
	/* Resulting polynomial */
	respoly = poly_z_zero_poly(pring, apoly);

	/* Temporary polynomial. */
	m_poly_create_empty(&tempph, m_poly_princvar(aph), 
					m_poly_least_pvar(aph), n);
	temp = m_poly_handle_to_poly(tempph);

	a_exp = b_exp = 0;
	for (i=0; (i < anterms); i++)
	{

		a_exp = m_poly_expt(aph, i);
		if (a_exp >= n)
			break;
		a = m_poly_coefft(aph, i);
		for (j=0; j < bnterms; j++)
		{
			b_exp = m_poly_expt(bph,j);
			if (b_exp >= (n-a_exp))
				break;

			b = m_poly_coefft(bph, j);
			m_poly_coefft(tempph, j) = integer_mult(a,b);
			/* Don't delref a or b since m_poly_coefft does not incref.*/
			m_poly_expt(tempph, j) = a_exp + b_exp;
		}
				

		m_poly_nterms(tempph) = j;
		addtemp = respoly;
		respoly = poly_z_add(pring, addtemp, temp);
		m_poly_z_delref(pring, addtemp);
	}
	m_poly_z_delref(pring, temp);

	return respoly;
}
