#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "poly_mat.h"
#include "zm.e"

t_handle
poly_u_zm_fact_b3 WITH_3_ARGS(
    t_handle,      pring,
    integer_big,   pdig,
    t_handle,        Qhdl
)
/*
** Step b3 in the Berlekamp factorization algorithm, ( triangularization )
** MODUPOLY_FACT_B3 : nullspace algorithm
** Given n x n Q-matrix over field Zpdig.
** Output : matrix of r vectors, v[1],...v[r], which are linearly
** independent over the field and satisfy v[i]Q = (0,...0),
** where n - r is the rank of Q.
*/
{
    t_handle           Vhdl;     /* t_handle to matrix of rowspace vectors */
    t_handle           Chdl;     /* t_handle to c-vector                   */
    t_int    nsize;    /* row-length of matrices               */
    t_int    rsize;    /* no. of rowspace vectors              */
    t_int    index;    /* matrix loop counter                  */
    t_int    k;
    t_int    j;
    t_int    col;
    t_int    row;
    t_poly        akjinv;    /* -inv( entry k,j of A )              */
    t_poly        akcol;     /* (k,col)th entry of matrix A         */
    t_poly        temp;
    t_poly        temp2;

    nsize = m_poly_mat_col( Qhdl );

    /* initialize vector matrix for nullspace      */
    /* allocate maximum amount of space V may need */
    Vhdl = poly_mat_new( nsize, nsize );

    /* initialize c-vector to be entirely negative */
    Chdl = poly_mat_new(1, nsize );

    for ( index = 1; index <= nsize; index++ )
    {
        m_poly_mat_entry( Chdl, index ) = -1;
    }

    rsize = 0;

    /* during calculation we will have C_j >= 0 only if           */
    /* Q_{c_{i,j}} = 1 and all other entries of row C_j are empty */

    for ( k = 1; k <= nsize; k++ )
    {
        j = 1;
        /* scan for row dependence */

        while ( ( j <= nsize ) &&
        	( ( m_poly_mat_elt( Qhdl, k, j ) == 0 ) ||
        	  ( m_poly_mat_entry( Chdl, j ) >= 0 ) ) )
        {
            j++;
        }

        if ( j <= nsize )
        {
            /* row dependence exists */

	    temp = modint_invert( pdig, m_poly_mat_elt( Qhdl, k, j ) );
	    akjinv = modint_negate( pdig, temp );

            /* multiply col j of A by -1/asubk,j */
            /* afterwards asubk,j should be -1   */

            for ( row = 1; row <= nsize; row++ )
            {
                m_poly_mat_elt( Qhdl, row, j ) = modint_mult( pdig, m_poly_mat_elt( Qhdl, row, j ), akjinv );
            }

            /* add ( (k,col)th entry of A * column j ) */
            /* to column col for all col != j          */

            for ( col = 1; col <= nsize; col++ )
            {
                akcol = m_poly_mat_elt( Qhdl, k, col );

		if ( col != j )
                {
		    for ( row = 1; row <= nsize; row++ )
                    {
			temp2 = modint_mult( pdig, m_poly_mat_elt( Qhdl, row, j ), akcol );

                        m_poly_mat_elt( Qhdl, row, col ) = modint_add( pdig, m_poly_mat_elt( Qhdl, row, col ), temp2 );
                    }
                }
            }

            /* these operations have no effect on rows 0,...,k-1 of A */

            m_poly_mat_entry( Chdl, j ) = k;
        }
        else
        {
            /* no row dependence, output a vector      */
            /* v[r] = ( v0,v1,...v(n - 1) ) defined by */
            /* vj = (k,s)th entry of A if Cs = j >= 0  */
            /*    = 1 if j == k                        */
            /*    = 0 otherwise                        */

            rsize++;

            for ( j = 1; j <= nsize; j++ )
            {
                index = 1;

                /* search for s s.t. Cs = j >= 0 */

                while ( ( index <= nsize )
                    && ( m_poly_mat_entry( Chdl, index ) != j ) )
                {
                    index++;
                }

                if ( index <= nsize ) 
                {
                    /* such s exists */
                    m_poly_mat_elt( Vhdl, rsize, j )
                        = m_poly_mat_elt( Qhdl, k, index );
                }
                else
                {
                    if ( j == k )
                    {
                        m_poly_mat_elt( Vhdl, rsize, j ) = 1;
                    }
                    else
                    {
                        m_poly_mat_elt( Vhdl, rsize, j ) = 0;
                    }
                }
            }
        }
    }

    m_poly_mat_row( Vhdl ) = rsize;

    mem_delete_hptr( &Chdl );

    return  Vhdl;
}
