#include "defs.h"
#include "globals.e"
#include "zm.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "error.e"

t_handle
poly_u_zm_factorize( pring, elt)
t_handle	pring;
t_poly		elt;
/*
 * Expects non-constant polys.
 * take out content and call poly_u_zm_fact
 */
{
	t_handle  flist;
	integer_big	a;
	t_integer	pdig; 

	DENY (m_poly_const (elt));
	ASSERT (m_poly_univariate (m_poly_poly_to_handle(elt)));
	if (poly_deg (elt) == 0)
        {
                flist = m_poly_z_faclst_alloc(1);
                poly_z_faclst_add_factor(flist, pring, elt, 1);
                return flist;
        }

	pdig = zm_modulus(m_poly_coeff_ring(pring));

	/* Ensure that the polynomial is monic. */
	a = poly_lbase_coefft(pring, elt);
	elt = modpoly_monic(pring, pdig, elt); 
	/* Don't delref elt - it isn't ours to delref! */
	flist = poly_u_zm_fact (pring, pdig, elt);
	poly_z_farray_add_content(pring, 1, a, flist);

	return flist;
}
