#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

t_poly
poly_u_zm_gcd WITH_4_ARGS(
        t_handle,       pring,
	integer_big,	pdig,
	t_poly,	apoly,
	t_poly,	bpoly
)
/*
** poly_u_zm_gcd : modular univariate polynomial greatest common divisor.
** apoly and bpoly are univariate polynomials over Zpdig,
** pdig is a prime.
** returns gcd(apoly, bpoly )
*/
{
	block_declarations;
	t_int	adeg;
	t_int	bdeg;
	t_poly		largevector;
	t_poly		smallvector;
	t_poly		largepoly;
	t_poly		remvector;
	t_poly		result;

	ASSERT ( m_poly_univariate (m_poly_poly_to_handle (apoly))  &&  m_poly_univariate (m_poly_poly_to_handle (bpoly)));

	if ( poly_z_is_zero_poly (pring, apoly))
	{
		return modpoly_monic( pring, pdig, bpoly );
	}

	if ( poly_z_is_zero_poly (pring, bpoly))
	{
		return modpoly_monic( pring, pdig, apoly );
	}

	ASSERT ( m_poly_princvar( m_poly_poly_to_handle( apoly )) ==   m_poly_princvar( m_poly_poly_to_handle( bpoly )));

	adeg = poly_deg( apoly );
	bdeg = poly_deg( bpoly );

	/* initialize largevector to whichever of apoly, bpoly has */
	/* higher degree, smallvector to whichever of apoly, bpoly */
	/* has lesser degree.					   */

	if ( adeg >= bdeg )	
	{
		largevector = m_modpoly_incref( pring, apoly );
		smallvector = m_modpoly_incref( pring, bpoly );
	}
	else 
	{
		largevector = m_modpoly_incref( pring, bpoly );
		smallvector = m_modpoly_incref( pring, apoly );
	}

	/* set largevector equal to smallvector				  */
	/* set smallvector to remainder( largevector/smallpoly ) mod pdig */
	/* until smallvector == 0 and largevector = gcd( apoly, bpoly )   */

	while ( ! poly_z_is_zero_poly (pring, smallvector))
	{
		remvector = poly_u_zm_nat_rem( pring, pdig, largevector, smallvector );

		m_modpoly_delref( pring, largevector );
		largevector = smallvector;
		smallvector = remvector;
	}

	largepoly = largevector;

	result = modpoly_monic( pring, pdig, largepoly );
	m_modpoly_delref( pring, largepoly );
	m_modpoly_delref( pring, smallvector );

	return result;
}

