#include "defs.h"
#include "poly.h"
#include "poly_z_faclst.h"
#include "error.e"
#include "zm.e"
#include "debug.e"

public t_logical
poly_z_dedekind_test(pring, apoly, prime)
t_handle	pring;
t_poly		apoly;
t_integer	prime;
{
	t_poly_context		context1;
	t_poly_ctx		context;
	t_handle	aph, flist;
	t_handle	mpring, zp;
	t_poly		fpoly, temp, temp1, zprod;
	t_int		len;
	t_poly		gpoly, hpoly, gmodp, hmodp, bpoly, rem;
	t_logical	res;
	t_int		i;

	context = &context1;
	poly_init_context(pring, context);

	aph = m_poly_poly_to_handle(apoly);

	ASSERT (m_poly_univariate (aph));
	ASSERT (poly_deg(apoly) > 0);
	
	zp = zm_str_create(prime, NH);
	/* Create poly ring over Z_prime */
	mpring = poly_str_create(zp, 1);

	/* fpoly = apoly in mpring */
	fpoly = poly_zm_reduce_modulo(mpring, apoly);

	/* factor fpoly */
	flist = poly_u_zm_factorize(mpring, fpoly);
	poly_elt_delete_crf(context, &fpoly);

	gpoly = poly_constant_dims_crf(context, 1, 1, 1);
	zprod= poly_constant_dims_crf(context, 1, 1, 1);
	/* Construct hpoly and gpoly */
	len = m_poly_z_faclst_len(flist);
	
	for (i = 0 ; i < len; i++)
	{
		temp = zprod;
		temp1 = poly_power_crf(context, m_poly_z_faclst_factor(flist, i), m_poly_z_faclst_power(flist, i));
		zprod = poly_mult_crf(context,zprod,temp1);
		poly_elt_delete_crf(context, &temp);

		if (m_poly_z_faclst_power(flist, i) > 1)
		{
			temp = gpoly;
			gpoly = poly_mult_crf(context,gpoly,temp1);
			poly_elt_delete_crf(context, &temp);
		}
		poly_elt_delete_crf(context, &temp1);
		IF_DEBUG_FLAG(DEBUG_POLY,
		{
			cay_print("poly_z_dedekind_test:loop : zprod\n");
			poly_elt_print_crf(context, pring,  zprod);
			cay_print("\n");
		}
		)
	}

	/* Calculate hpoly */
	temp = poly_subtract_crf(context, apoly, zprod);
	poly_elt_delete_crf(context, &zprod);
	temp1 = poly_constant_dims_crf(context, 1, 1, prime);
	IF_DEBUG_FLAG(DEBUG_POLY,
	{
		cay_print("poly_z_dedekind_test:temp\n");
		poly_elt_print_crf(context, pring, temp);
		cay_print("poly_z_dedekind_test:temp1\n");
		poly_elt_print_crf(context, pring, temp1);
		cay_print("\n");
	}
	)
	temp = poly_clean_crf(context, temp);
	temp1 = poly_clean_crf(context, temp1);
	poly_z_quot_rem(pring, temp, temp1, &hpoly, &rem);
	hpoly = poly_clean_crf(context, hpoly);
	rem = poly_clean_crf(context, rem);

	ASSERT(poly_is_zero_crf(context, rem));
	poly_elt_delete_crf(context, &rem);
	poly_elt_delete_crf(context, &temp);
	poly_elt_delete_crf(context, &temp1);

	hmodp = poly_zm_reduce_modulo(mpring, hpoly);
	gmodp = poly_zm_reduce_modulo(mpring, gpoly);
	poly_elt_delete_crf(context, &hpoly);
	poly_elt_delete_crf(context, &gpoly);

	bpoly = poly_zm_gcd(mpring, hmodp, gmodp);
	poly_elt_delete_crf(context, &hmodp);
	poly_elt_delete_crf(context, &gmodp);
	res = (poly_deg(bpoly) == 0);
	poly_elt_delete_crf(context, &bpoly);
	poly_str_delete(0, &mpring);
	zm_str_delete(0, &zp);
	return res;
}


