
#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_exp WITH_3_ARGS(
    t_handle,        pring,
    t_poly,       apoly,
    t_int,   power
)
/*
*        IPOLY_EXP : integral polynomial exponentation.
*        apoly is a polynomial , power is a non-negative beta-integer
*        returns apoly^power
*/
{
    block_declarations;
    t_poly        bpoly;
    t_poly        cpoly;
    t_int    ndash;
    t_poly        temp;

    if ( m_poly_const( apoly ) )
    {
        /* apoly constant and non-zero, power > 0 */
        return  integer_power( apoly, power );
    }

    if ( power == 0 )
    {
        return  poly_z_constant_poly (pring, apoly, 1);
    }

    /* apoly not constant, power non-zero, general case */

    bpoly = poly_z_constant_poly (pring, apoly, 1);
    cpoly = m_poly_z_incref( pring, apoly );
    ndash = power;

    for ( ;; )
    {
        if ( ndash & 1 )
        {
	    temp = bpoly;
            bpoly = poly_z_mult( pring, temp, cpoly );
            m_poly_z_delref( pring, temp );
        }

        if ( (ndash >>= 1) == 0 )
	    break;

	temp = cpoly;
        cpoly = poly_z_mult( pring, temp, temp );
	m_poly_z_delref( pring, temp );
    }

    m_poly_z_delref( pring, cpoly );
    return  bpoly;

} /* poly_z_exp() */

