#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"

void
poly_z_faclst_add_factor WITH_4_ARGS(
    t_handle,             resmh,
    t_handle,           pring,
    t_poly,          entry,
    t_int,      power
)
/*
** adds entry^power to the factorisation stored in the matrix resmh
*/
{
    t_int    j;
    t_int    nfactors;

    nfactors = m_poly_z_faclst_len( resmh );

    for ( j=0; j<nfactors; ++j )
    {
	if ( !poly_z_different( pring, entry, m_poly_z_faclst_factor( resmh, j )))
	{
	    /* same factor found */

	    break;
	}
    }

    if ( j < nfactors )
    {
	/* combine factors */

	m_poly_z_faclst_power( resmh, j ) += power;
    }
    else
    {
	/* add factor to end */

	m_poly_z_faclst_assure_space( resmh, nfactors+1 );

	m_poly_z_faclst_factor( resmh, nfactors ) = m_poly_z_incref( pring, entry );
	m_poly_z_faclst_power( resmh, nfactors ) = power;

	m_poly_z_faclst_len_put( resmh, nfactors+1 );
    }
}

