
#include "defs.h"
#include "integer.e"
#include "poly.h"

void
poly_z_handle_delref WITH_2_ARGS(
    t_handle,  pring,
    t_handle,  aph
)
/*
**   IPOLY_HANDLE_DELREF :delrefs the polynomial specified by t_handle aph
*/
{
    block_declarations;
    t_int    nterms;
    t_int    count;
    t_poly        temp;

    if ( block_has_other_refs( aph ) )
    {
	block_decref_delete( aph );
        return;
    }

    nterms = m_poly_nterms( aph );

    for ( count = 0; count < nterms; count++ )
    {
	temp = m_poly_coefft( aph, count );
        m_poly_z_delref( pring, temp );
    }

    block_decref_delete( aph );
}

