#include "principal_ideal.e"

t_logical
principal_ideal_is_member(ideal, elt_id, elt)
t_handle	ideal, elt_id;
t_pi_elt	elt;
/*
** Test elt in ideal
** true iff ideal.generator | (elt_id.generator * elt)
*/
{

	t_pi_context    context;
	t_pi_ctx	ctx;
	t_handle	ring, ring2, g, h, temp;
	t_int		it;	
	t_pfh		elt_mult, elt_quotrem;
	t_pfl		is_zero;
	t_pfv		elt_delete;
	t_logical	res;
	t_handle	q, r;

	ctx = &context;
	pi_ctx_init(ideal, ctx);
	elt_mult = m_pi_ctx_elt_mult(ctx);
	elt_quotrem = m_pi_ctx_elt_quotrem(ctx);
	elt_delete = m_pi_ctx_elt_delete(ctx);
	is_zero = m_pi_ctx_is_zero(ctx);
	ASSERT(elt_mult);
	ASSERT(elt_quotrem);
	ASSERT(elt_delete);
	ASSERT(is_zero);

	g = m_pi_generator(ideal);
	h = m_pi_generator(elt_id);
	ring = m_pi_ring(ideal);
	ring2 = m_pi_ring(elt_id);
	if (ring != ring2)
		return FALSE;

	(*elt_mult)(ring, h,0, elt, 0, &temp, &it);
	(*elt_quotrem)(ring, temp, g, &q, &r);
	
	(*elt_delete)(ring, &q);
	res = (*is_zero)(ring, r); 
	(*elt_delete)(ring, &r);

	return res;
}
	
t_logical
principal_ideal_is_subideal(I, J)
t_handle	I, J;
/*
** I = <i>, J = <j>
** I in J iff j | i
*/
{
	t_pi_context    context;
	t_pi_ctx	ctx;
	t_handle	i, j;
	t_handle	ring, ring2;
	t_pfh		elt_quotrem;
	t_pfl		is_zero;
	t_pfv		elt_delete;
	t_logical	res;
	t_handle	q, r;

	i = m_pi_generator(I);
	j = m_pi_generator(J);
	ring = m_pi_ring(I);
	ring2 = m_pi_ring(J);
	if (ring != ring2)
		return FALSE;

	ctx = &context;
	pi_ctx_init(I, ctx);

	elt_quotrem = m_pi_ctx_elt_quotrem(ctx);
	elt_delete = m_pi_ctx_elt_delete(ctx);
	is_zero = m_pi_ctx_is_zero(ctx);
	ASSERT(elt_delete);
	ASSERT(elt_quotrem);
	ASSERT(is_zero);

	(*elt_quotrem)(ring,i, j, &q, &r);
	(*elt_delete)(ring, &q);
	res = (*is_zero)(ring, r);
	(*elt_delete)(ring, &r);

	return res;
}
