#include "defs.h"
#include "ring.e"
#include "principal_ideal.e"

t_logical
principal_ideal_str_equal(id1, id2)
t_handle	id1, id2;
{

	t_pi_context    context;

        pi_ctx_init(id1, &context);
        return pi_str_equal_ctx(&context, id1, id2);
}

t_logical pi_str_equal_ctx(context, id1, id2)
t_pi_ctx	context;
t_handle	id1, id2;
{
        t_pfl           elt_equal;
	t_handle	g1, g2, ring1, ring2;
	
	g1 = m_pi_generator(id1);
	g2 = m_pi_generator(id2);
	ring1 = m_pi_ring(id1);
	ring2 = m_pi_ring(id2);
	if (!ring_str_equal(ring1, ring2))
		return FALSE;
	elt_equal = m_pi_ctx_elt_equal(context);
	ASSERT(elt_equal);

        return (*elt_equal)(ring1, g1, 0, ring2, g2, 0);
}


