#include "defs.h"
#include "globals.e"
#include "integer.e"
#include "q.h"
#include "error.e"

public t_handle
glue_q_abs(str, elt)
t_handle str, elt;
{
	return( q_abs( str, elt ));
}

public t_handle
glue_q_add(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = q_add( s1, e1, e2 );
}

public t_handle
glue_q_ceiling(s, e)
t_handle s, e;
{
	return( q_ceil( s, e ));
}

public t_handle
glue_q_denom(s, r)
t_handle s, r;
{
    block_declarations;
    integer_big		temp;

    if (r == 0)
    {
		error_runtime( ERR_UNKNOWN );
    }

    q_fix_sign(r);

    temp = q_denom( r );
    return integer_incref( temp );
}

public t_handle
glue_q_eq(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
	return( q_compare( s1, e1, e2 ) == 0 );
}

public t_handle
glue_q_floor(s, e)
t_handle s, e;
{
	return( q_floor( s,e ));
}

public t_handle
glue_q_ge(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
	return( q_compare( s1, e1, e2 ) >= 0 );
}

public t_handle
glue_q_gt(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
	return( q_compare( s1, e1, e2 ) > 0 );
}

public t_handle
glue_q_is_minus_one(str, elt)
t_handle str, elt;
{
	return( q_compare( str, elt, Q_MINUS_ONE ) == 0 );
}

public t_handle
glue_q_is_one(str, elt)
t_handle str, elt;
{
	return( q_compare( str, elt, Q_ONE ) == 0 );
}

public t_handle
glue_q_is_zero(str, elt)
t_handle str, elt;
{
	return( elt == 0 );
}

public t_handle
glue_q_le(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
	return( q_compare( s1, e1, e2 ) <= 0);
}

public t_handle
glue_q_lt(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
	return( q_compare( s1, e1, e2 )  < 0 );
}

public t_handle
glue_q_max(str, e1, e2)
t_handle str, e1, e2;
{
	if (q_compare(str, e1, e2) >= 0)
		return( q_incref(e1));
	else
		return( q_incref(e2));
}

public t_handle
glue_q_min(str, e1, e2)
t_handle str, e1, e2;
{
	if (q_compare(str, e1, e2) >= 0)
		return( q_incref(e2));
	else
		return( q_incref(e1));
}

public t_handle
glue_q_mult (str, e1, it1, e2, it2, res_e, res_it)
t_handle str, e1, it1, e2, it2, *res_e, *res_it;
{
	*res_e = q_mult( str, e1, e2 );
}

public t_handle
glue_q_negate(s, e, res_e)
t_handle s, e, *res_e;
{
	*res_e = q_negate( s, e );
}

public t_handle
glue_q_numer(s, r)
t_handle s, r;
{
    block_declarations;
    integer_big	temp;

    if( r == 0 )
    {
		return 0;
    }

    q_fix_sign(r);

    temp = q_numer( r );
    return( integer_incref( temp ));
}

public t_handle
glue_q_power(s1, e1, it1, n, res_s, res_e, res_it)
t_handle s1, e1, it1, n, *res_s, *res_e, *res_it;
{
	*res_e = q_power( s1, e1, n );
	*res_s = m_q_str_incref( structure_q );
}

public t_handle
glue_q_round(s, e)
t_handle s, e;
{
	return( q_round( s, e ));
}

public t_handle
glue_q_sign(s, e)
t_handle s, e;
{
	return( q_compare(s, e, 0));
}

public t_handle
glue_q_slash(s1, e1, e2)
t_handle s1, e1, e2;
{
        if (s1 == structure_z) 
                return q_make( s1, e1, e2 );
                /* This has been called as an element constructor. */
        else 
                return q_divide(s1, e1, e2); 

}

public t_handle
glue_q_subtract(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = q_subtract( s1, e1, e2 );
}

public t_handle
glue_q_inverse(str, elt, it, res_elt, res_it)
t_handle str, elt, it, *res_elt, *res_it;
{
    *res_it = 0;
    *res_elt = q_inverse(str, elt);
}

public t_handle
glue_q_degree(str, elt)
t_handle str, elt;
{
	return 1;
}

public t_handle
glue_q_rhs_index(p, s, i, res_s, res_e, res_it)
t_handle p, s, i, *res_s, *res_e, *res_it;
{
	if (i == 0)
	{
		*res_s = m_q_str_incref(p);
		*res_e = q_incref(s);
		*res_it = 0;
		return NH;
	}
		error_runtime(ERR_UNKNOWN);
}

#ifndef KANT
public t_handle
glue_q_integral_basis(pr, r)
t_handle pr, r;
{
	return q_integral_basis(pr, r);
}
#endif
