#include "defs.h"
#include "integer.e"
#include "q.h"

rational
q_inverse WITH_2_ARGS(
	t_handle,		field,
	rational,	a
)
/*
Returns the inverse of a.
*/
{
    block_declarations;
    rational		new;

    DENY(a == 0);

    new = q_new();
    q_numer(new) = integer_incref(q_denom(a));
    q_denom(new) = integer_incref(q_numer(a));

    return new;
}

