
#include "defs.h"
#include "mp.e"
#include "real.e"

t_real
real_arcsinh WITH_2_ARGS(
	t_handle,		r,
	t_real,		t
)
/*
** Returns arcsinh( t );
*/
{
	mp_float	tf, resf, t1;

	real_make_mp( t, tf );
	t1 = mp_alloc( real_base, real_beta_prec( r ));
	resf = mp_alloc( real_base, real_beta_prec( r ));

	mp_mul( tf, tf, t1 );
	mp_add_int( t1, 1, t1 );
	mp_sqrt( t1, t1 );
	mp_add( t1, tf, t1 );
	mp_log( t1, resf );

	mp_delete_float( t1 );

	return mp_to_real( resf );
}
