
#include "defs.h"
#include "real.e"
#include "mp.e"

t_real
real_besj WITH_3_ARGS(
	t_handle,		r,
	t_real,		x,
	t_int,	nu
)
/*
** Returns J(nu, x), first-kind Bessel fucntion of order nu.
*/
{
	mp_float	xf;
	mp_float	yf;

	real_make_mp( x, xf );
	yf = mp_alloc( real_base, real_beta_prec( r ));
	mp_besj( xf, nu, yf );

	return mp_to_real( yf );
}

