
#include "defs.h"
#include "real.e"
#include "mp.e"


t_real
real_log WITH_2_ARGS(
	t_handle,		r,
	t_real,		x
)
/*
** Returns log( x ).
*/
{
	mp_float	xf, f;

	real_make_mp( x, xf );
	f = mp_alloc( real_base, real_beta_prec( r ));
	mp_log( xf, f );

	return mp_to_real( f );
}


t_real
real_logb WITH_3_ARGS(
	t_handle,		r,
	t_real,		b,
	t_real,		a
)
/*
** Returns log_b( a ).
*/
{
	mp_float	af, bf, laf, resf;

	real_make_mp( b, bf );
	real_make_mp( a, af );
	laf = mp_alloc( real_base, real_beta_prec( r ));
	resf = mp_alloc( real_base, real_beta_prec( r ));
	mp_log( af, laf );
	mp_log( bf, resf );
	mp_div( laf, resf, resf );
	mp_delete_float( laf );

	return mp_to_real( resf );
}

