
#include "defs.h"
#include "integer.e"
#include "z.h"
#include "error.e"

t_void
z_power WITH_7_ARGS(
	t_handle,		ring,
	integer_big,	a,
	t_int,          it1,
	integer_big,	b,
	t_handle *,     res_s,
	integer_big *,  res_e,
	t_int *,        res_it
)
/*
** exponentiation in Z of a and b
*/
{
	if (b == 0 && a == 0)
	    error_runtime(ERR_ZERO_POWER_ZERO);

	if (!integer_is_single(b))
	    error_runtime( ERR_ARG_TOO_BIG, 2, b);
	if (b < 0)
	    error_runtime(ERR_ARG_LT_INT, 2, b, 0);

	*res_e = integer_power( a, b );
	*res_s = m_z_str_incref (ring);
	*res_it = 0;
	return;
}

