#include "kant.h"


t_void
anf_rel_field_disc_2_fac WITH_7_ARGS (order       , ord,
                                      anf_elt     , my,
                                      t_handle      , faclst_2,
                                      t_handle *    , faclst_my,
                                      t_handle *    , faclst_disc,
                                      t_handle *    , faclst_index,
                                      anf_ideal * , disc_2     )
                                                             
{
                block_declarations;
                                                    
                anf_ideal         ideal,temp1,temp2;       

                anf_elt           ny;
                integer_small     ideal_power,index_power,disc_power,u;
                integer_small     i,j,len,bound,pos;




  
  /* We are going to step through the ideals stored in faclst_2 */
  /* and check for each of these ideals whether or not they are */
  /* dividing my , too.                                         */

  len = m_poly_z_faclst_len (faclst_2);            


  for (i=0;i<len;i++)
  { 
    
    ideal = m_poly_z_faclst_factor (faclst_2,i);
    pos   = anf_ideal_is_in_faclst (ord,ideal,*faclst_my);
    
   

    if (pos < 0)   /* This ideal is not lying above my */
    {                                           

/* Since we want to compute the index too we need to know the maximal */
/* power of ideal dividing 4*my. We store the value in "sum"          */ 

      ideal_power = 2*m_poly_z_faclst_power (faclst_2,i); 
      
/* We have to check if alpha is a square modulo ideal^j for j<=bound  */
      bound       = 2*m_poly_z_faclst_power (faclst_2,i);

      u = find_max_power (ord,ideal,my,&ny,bound);   
      if (u > 0)
        anf_elt_delete (ord,&ny);       

      if (u == 0)
        disc_power = ideal_power;    
      else
        if (u == 2*m_poly_z_faclst_power (faclst_2,i)) 
          disc_power = 0;
         else
          disc_power = ideal_power - u + 1;

    } 
    else   /* this ideal divides my ,too */                
      {
       /* Check if my followes our special assumption */
 
        if (m_poly_z_faclst_power (*faclst_my,pos) >1)
          error_internal ("ANF_REL_FIELD_DISC_2_FAC : Power of ideal above 2 in my larger than 1");
      
        ideal_power = 2*m_poly_z_faclst_power (faclst_2,i)+1;
        disc_power  = ideal_power;
        m_poly_z_faclst_power (*faclst_my,pos) = -m_poly_z_faclst_power (*faclst_my,pos);
      }

                                                  
       
/* First store the field - disc */   
    if (disc_power >0)
    {
      anf_ideal_add_to_faclst (ord,faclst_disc,ideal,disc_power);

      if (*disc_2 == MEM_NH)  /* We compute the part of the index above 2 here, too */
        *disc_2 = anf_ideal_power (ord,ideal,disc_power);
      else
        {                                   
             
          temp1 = anf_ideal_power (ord,ideal,disc_power);
          temp2 = anf_ideal_mult (ord,temp1,*disc_2); 

          anf_ideal_delete (ord,disc_2); 
          anf_ideal_delete (ord,&temp1); 

          *disc_2 = temp2;                                                       
        }
    }
/* Ok this was the disc. */


/* Now store the index   */

    index_power = ideal_power - disc_power;  
   
    if ( index_power > 0)
      anf_ideal_add_to_faclst (ord,faclst_index,ideal,index_power);

  }
}
