#include <stdio.h>         
#include "kant.h" 
#include "anf.h" 
#include "real.e"


t_logical
anf_ceiling_fincke_init_aj  WITH_4_ARGS( 
	order,		ord,
	anf_ceiling *,	ceil,
	vector,          rbounds_lower,
	vector,          rbounds_upper
)
/*******************************************************************************
 
Description:
 
	The function create a ceiling and returns the first vector 
	(= (0,...,0) )    for the ellipsoid method of U. Fincke.

 
Calling sequence:
 
	log= anf_ceiling_fincke_init(ord, ceil);
 
      	order  	        ord      = t_handle of an order 
      	anf_ceiling     ceil     = t_handle of an ceiling
	t_logical	log	 = 1

 
History:
 
	92-06-11 AJ    written
 
*******************************************************************************/
{  
	block_declarations;
                              
	t_handle		R;
	integer_small	i, j, sum, r1, r2, neqnum, test, nm;   
          
	R= order_reals(ord);            
        nm= order_abs_degree(ord);
	r1= order_r1(ord);
	r2= order_r2(ord);

	*ceil= anf_ceiling_alloc(ord);

	for (i=1; i<=nm; i++)
	 {
	  if (vec_entry(rbounds_upper,i)>=0)
	   {
	    if (vec_entry(rbounds_lower,i)>=0)
	      anf_ceiling_rexp(*ceil,i)= vec_entry(rbounds_lower,i);
	     else
	      anf_ceiling_rexp(*ceil,i)= 0;
	   }
	  else
            anf_ceiling_rexp(*ceil,i)= vec_entry(rbounds_upper,i);
	 }   
	
        sum= 0;
        for (i=1; i<=nm; i++)
         sum= sum + anf_ceiling_rexp(*ceil,i);
      
        if (sum==0)
         {
          if (r2>0)
           {
            neqnum= 0;  
            test= 1;
            for (j= r1+1; j<=r1+r2; j++)
             {
     	      if ( ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))<0) ||
	           ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))>1)  )  
	       {
	        test= 0;
	        break;
	       }
	      if ( ( anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j)) != 0 )
 	        neqnum= neqnum+1;
	      if (neqnum>1)  break;
	     }
	    if ( (neqnum<=1) && (test) )   
             {
	      for (j= 1; j<=nm; j++)
	       {
	        anf_ceiling_lambda(*ceil,j)= 
	           real_power(R, order_fincke_lambda(ord), anf_ceiling_rexp(*ceil,j));
	       }

              return 1;                                       
             }
	   }
	  else 
           {
	    for (j= 1; j<=nm; j++)
	     {
	      anf_ceiling_lambda(*ceil,j)= 
	         real_power(R, order_fincke_lambda(ord), anf_ceiling_rexp(*ceil,j));
	     }
           
            return 1;                                       
           }
	 }       

        return 0;
} 

