#include <stdio.h>         
#include "defs.h" 
#include "anf.h" 
#include "real.e"


integer_small
anf_elts_same_con_aj WITH_4_ARGS(
	order,		ord,
	order,		ord_sub,
	anf_elt,	a_elt,
	anf_elt,	b_elt_sub
)
/*******************************************************************************
 
AJ January 1992
Last modification: -

 
 
 
Description:
 
	Test if an element a_elt of E/F is equal to a conjugate
	of b_elt_sub in o_F (a_elt, b_elt_sub both in conjugated form;
	the orders must have the same reals; b_elt_sub must be a primitive 
	element of F):

		1	if a_elt is equal to a conjugate of b_elt_sub
		0	if a_elt is not equal to a conjugate of b_elt_sub

 
Calling sequence:
 
	flag= anf_elts_same_con_aj(ord, ord_sub, a_elt, beta_elt_sub);
 
	integer_small	flag
      	order       	ord        = t_handle of order 
      	order       	ord_sub    = t_handle of an order of a subfield
      	anf_elt     	a_elt      = algebraic number in ord (conjugates)
      	anf_elt     	b_elt_sub  = algebraic number in ord_sub (conjugates)
      
 
History:
 
	92-02-04 AJ    written
 
*******************************************************************************/
{
 	block_declarations;         

 	int		i,j, is_real;
        integer_small   erg, erg2, r1, r2, r1_sub, r2_sub;
   	t_handle        reals, reals_sub;
        t_real          loceps, a, ac, b, bc, zero, sq2, h1;
        anf_elt         a_elt_con, b_elt_sub_con;

                                    
/*** Initialisation  **********************************************************/

        r1= order_r1(ord);
        r2= order_r2(ord);

        r1_sub= order_r1(ord_sub);
        r2_sub= order_r2(ord_sub);

	sq2  = order_sqrt_2(ord);

        reals = order_reals(ord); 
        loceps= real_make(reals, 10, -real_dec_prec(reals)+2 );  
        zero= conv_int_to_real(reals,0);

      	if (anf_elt_is_con(a_elt))
	  a_elt_con = anf_elt_incref(a_elt);
	else
	  a_elt_con = anf_elt_con(ord, a_elt);    

      	if (anf_elt_is_con(b_elt_sub))
	  b_elt_sub_con = anf_elt_incref(b_elt_sub);
	else
	  b_elt_sub_con = anf_elt_con(ord_sub, b_elt_sub);    

        if (anf_print_level>6)
         {
          printf("\nb_elt_sub_con: \n");
          anf_elt_write(ord_sub, b_elt_sub_con);
          printf("\na_elt_con: \n");
          anf_elt_write(ord, a_elt_con);
         }



/*** Comparisation ************************************************************/
                        
	is_real= 0;
        if ( r1 != 0 ) 
	  { 
           a= real_incref(anf_con(a_elt_con, 1));
	   is_real= 1;
	  }
	 else
	  {
           a= real_incref(anf_con(a_elt_con, 1));
           ac= real_abs(reals, anf_con(a_elt_con, r2+1));
	   if (real_equality_eps(reals, ac, zero, loceps))
	    {
  	     real_delete(&ac);
	     is_real= 2; 
	    }
	   real_delete(&zero);
	  }

        if ( is_real != 0 )  
          /* if the first conjugate of a_elt_con is real */
          {
	   for (i= 1;i<= r1_sub; i++)         
	     {
              b= real_incref(anf_con(b_elt_sub_con, i)); 		    
	      if (is_real==2)
	       { 
	        h1= b;
	        b= real_mult(reals, b, sq2);
		real_delete(&h1);
	       }
              erg= real_equality_eps(reals, a, b, loceps);

  	      if (anf_print_level >=5 )
     	       {
                printf("\nanf_elts_same_con_aj:\n"); 		   
                printf("Real (%d):\n",i); 		   
                real_write_aj(reals, a, 20); printf("\n");
                real_write_aj(reals, b, 20); printf("\n");
  	        printf("Result:  %d\n\n", erg); 		   
	       }

              if (erg)  
                {
                 real_delete(&a);     
                 real_delete(&b);     
	         anf_elt_delete(ord_sub, &b_elt_sub_con);
	         anf_elt_delete(ord, &a_elt_con);
	  	 real_delete(&loceps);

		 return 1;   
	        }

              real_delete(&b);     

       	     }  /* end for */

           real_delete(&a);

          } /*  end then */
         else
          /* if the first conjugate of a_elt_con is complex */
          {      
	   for (i= 1;i<= r2_sub; i++)         
	     {  
              b= real_incref(anf_con(b_elt_sub_con, i)); 		    
              erg= real_equality_eps(reals, a, b, loceps);

  	      if (anf_print_level >=5 )
	       {
                printf("\nanf_elts_same_con_aj:\n"); 		   
                printf("Complex (%d):\n",i); 		 
                real_write_aj(reals, a, 20); printf("\n");
                real_write_aj(reals, b, 20); printf("\n");
                printf("Result:  %d\n\n", erg);
	       }

              real_delete(&b);     
            
       	      if (erg)
               /* if the real parts are equal we test the absolute values
 	          of imaginary parts */
	       {                            
                bc= real_abs(reals, anf_con(b_elt_sub_con, r2_sub+i)); 		    
                erg2= real_equality_eps(reals, ac, bc, loceps);

  	        if (anf_print_level >=5 )
	         {
                  printf("\nanf_elts_same_con_aj:\n"); 		   
                  printf("Con. complex absolute (%d):\n",i); 		   
                  real_write_aj(reals, ac, 20); printf("\n");
                  real_write_aj(reals, bc, 20); printf("\n");
  	          printf("Result:  %d\n\n", erg2); 		   
	         }

                real_delete(&bc);     

                if (erg2)  
		 /* real parts and absolute values of imaginary parts equal */ 
                 {
        	   real_delete(&a);
        	   real_delete(&ac);
	   	   real_delete(&loceps);
	           anf_elt_delete(ord_sub, &b_elt_sub_con);
	           anf_elt_delete(ord, &a_elt_con);

		   return 1;   
	         }               

 	       } /* endif: erg */

       	     } /* end for */   

            real_delete(&a);
            real_delete(&ac);

          } /* endif */    

/*** End: there are no same conjugates ****************************************/

	real_delete(&loceps);
        anf_elt_delete(ord_sub, &b_elt_sub_con);
	anf_elt_delete(ord, &a_elt_con);

	return 0;

} 

