#include "kant.h"
#include "thue.h"



thue
thue_create WITH_1_ARG(
integer_small,   n
)
/*******************************************************************************
 
Description:	Allocating space for a thue equation
		The task of this routine is to allocate sufficient space for
		the table which describes a thue equation. 
 
		The invariants of the thue equation are set to t_void.
 
Calling sequence:
 
                 th = thue_create(n);
                        n       =       degree of thue equation
                        th      =       t_handle to thue object
 
History:
 
	92-09-03 JPS     written
 
*******************************************************************************/
{
	block_declarations;
	thue th;    
	th = mem_alloc_zero(sizeof(t_thue_table));
 
	block_init(th, THUE_BLOCK_TYPE);

	thue_abs_degree(th)=n; 
        thue_coeff_alloc(th);
        thue_order(th) = MEM_NH;

        thue_reals(th) = real_str_create(20);
 
 
	return th;
}

