#include "kant.h"
#include "thue.h" 

vector
thue_waldschmidt_Vi WITH_3_ARGS(
                thue,           th,
                t_real,         D,
                integer_small,  nr
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	i, j, deg, r;
	t_handle	R;
	t_real		h1, h2, h3, v0;
        order           ord;
        vector          alpha, v;
        
        deg = thue_abs_degree(th);
        ord = thue_order(th);
        R = thue_reals(th);
        r = order_r(ord);

        alpha = vec_new(r+1);
        for (j=1; j<=r+1; j++)
                { 
                h1 = vec_entry(thue_ith_delta(th, nr), j); 
                vec_entry(alpha, j) = real_abs(R, h1);
                }
        v = vec_new(r+1);
        h1 = conv_int_to_real(R, 1);
        v0 = real_divide(R, h1, D);
        real_delete(&h1);
        h1 = thue_anf_elt_height(th, 1);
        if (thue_print_level(th) >= 5)
                {
		printf("Hoehe = ");real_write(R, h1, 20);puts(""); 
                }
        h2 = real_log(R, vec_entry(alpha, 1));
        h3 = real_abs(R, h2);
        real_delete(&h2);
        h2 = real_divide(R, h3, D);
        if (thue_print_level(th) >= 5)
                {
		printf("        ");real_write(R, h2, 20);puts("");
                }
        real_delete(&h3);
        h3 = real_max(R, h1, h2);
        real_delete(&h1);
        real_delete(&h2);
        vec_entry(v,1) = real_max(R, v0, h3);
        real_delete(&h3);
        real_delete(&v0);
        for (i=2; i<=r+1; i++)
                {
                h1  = thue_anf_elt_height(th, i);
	        if (thue_print_level(th) >= 5)
                        {
			printf("Hoehe = ");real_write(R, h1, 20);puts("");
                        }
                h2 = real_log(R, vec_entry(alpha, i) );
                h3 = real_abs(R, h2);
                real_delete(&h2);
                h2 = real_divide(R, h3, D);
	        if (thue_print_level(th) >= 5)
                        {
			printf("        ");real_write(R, h2, 20);puts("");
                        }
                real_delete(&h3);
                h3 = real_max(R, h1, h2);
                real_delete(&h1);
                real_delete(&h2);
                vec_entry(v,i) = real_max(R, vec_entry(v, i-1), h3);
                real_delete(&h3);
                }
        vec_delete(R, &alpha);
        return v;
}
 

