      SUBROUTINE CMINP2(FLAG)
C
C     ***************************************************************
C     *                                                             *
C     *                    S U B R O U T I N E                      *
C     *                                                             *
C     *                        C M I N P 2                          *
C     *                                                             *
C     ***************************************************************
C
*DOC             Adapter for COMINP
**DOC
*INDEX  CMINCON(FI/2): Conversion of common field data 
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       Interface routine for calling programs from other systems
**DOC       which have to use KANT-COMINP.
**DOC       This routine calls COMINP and sets FLAG to one if there
**DOC       were data read.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       Field data
**DOC       FLAG                = 1   there are data
**DOC                           = 0   EOF
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       dependent on COMINP
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       COMINP
**DOC 
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       27.09.91
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       -        -         -
**DOC
%include 'larith.inc'
%include 'field.inc'
%include 'lfield.inc'
*
      INTEGER FLAG, I, J
*
*  Reading data
*            
      FLAG = 0
      CALL COMINP(*9)
      FLAG = 1
*
*  Storing units to long
*
      IF ( EXFLAG(3).EQ.0 .AND. EXFLAG(2).GT.0 ) THEN
         DO 100 J=1,EXFLAG(2)
            DO 100 I=N,1,-1
100            CALL SLSTO(FUNIT(I,J),LFUNIT(1,I,J))
      ENDIF
* 
9     RETURN 
      END  
